/*
 * Copyright 2016-2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.fms.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/PutAppsList" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class PutAppsListRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * The details of the Firewall Manager applications list to be created.
     * </p>
     */
    private AppsListData appsList;
    /**
     * <p>
     * The tags associated with the resource.
     * </p>
     */
    private java.util.List<Tag> tagList;

    /**
     * <p>
     * The details of the Firewall Manager applications list to be created.
     * </p>
     * 
     * @param appsList
     *        The details of the Firewall Manager applications list to be created.
     */

    public void setAppsList(AppsListData appsList) {
        this.appsList = appsList;
    }

    /**
     * <p>
     * The details of the Firewall Manager applications list to be created.
     * </p>
     * 
     * @return The details of the Firewall Manager applications list to be created.
     */

    public AppsListData getAppsList() {
        return this.appsList;
    }

    /**
     * <p>
     * The details of the Firewall Manager applications list to be created.
     * </p>
     * 
     * @param appsList
     *        The details of the Firewall Manager applications list to be created.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public PutAppsListRequest withAppsList(AppsListData appsList) {
        setAppsList(appsList);
        return this;
    }

    /**
     * <p>
     * The tags associated with the resource.
     * </p>
     * 
     * @return The tags associated with the resource.
     */

    public java.util.List<Tag> getTagList() {
        return tagList;
    }

    /**
     * <p>
     * The tags associated with the resource.
     * </p>
     * 
     * @param tagList
     *        The tags associated with the resource.
     */

    public void setTagList(java.util.Collection<Tag> tagList) {
        if (tagList == null) {
            this.tagList = null;
            return;
        }

        this.tagList = new java.util.ArrayList<Tag>(tagList);
    }

    /**
     * <p>
     * The tags associated with the resource.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setTagList(java.util.Collection)} or {@link #withTagList(java.util.Collection)} if you want to override
     * the existing values.
     * </p>
     * 
     * @param tagList
     *        The tags associated with the resource.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public PutAppsListRequest withTagList(Tag... tagList) {
        if (this.tagList == null) {
            setTagList(new java.util.ArrayList<Tag>(tagList.length));
        }
        for (Tag ele : tagList) {
            this.tagList.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The tags associated with the resource.
     * </p>
     * 
     * @param tagList
     *        The tags associated with the resource.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public PutAppsListRequest withTagList(java.util.Collection<Tag> tagList) {
        setTagList(tagList);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getAppsList() != null)
            sb.append("AppsList: ").append(getAppsList()).append(",");
        if (getTagList() != null)
            sb.append("TagList: ").append(getTagList());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof PutAppsListRequest == false)
            return false;
        PutAppsListRequest other = (PutAppsListRequest) obj;
        if (other.getAppsList() == null ^ this.getAppsList() == null)
            return false;
        if (other.getAppsList() != null && other.getAppsList().equals(this.getAppsList()) == false)
            return false;
        if (other.getTagList() == null ^ this.getTagList() == null)
            return false;
        if (other.getTagList() != null && other.getTagList().equals(this.getTagList()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getAppsList() == null) ? 0 : getAppsList().hashCode());
        hashCode = prime * hashCode + ((getTagList() == null) ? 0 : getTagList().hashCode());
        return hashCode;
    }

    @Override
    public PutAppsListRequest clone() {
        return (PutAppsListRequest) super.clone();
    }

}
