/*
 * Copyright 2017-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.prometheus.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * <p>
 * Represents the output of a DescribeRuleGroupsNamespace operation.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/amp-2020-08-01/DescribeRuleGroupsNamespace" target="_top">AWS
 *      API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class DescribeRuleGroupsNamespaceResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable, Cloneable {

    /**
     * <p>
     * The selected rule groups namespace.
     * </p>
     */
    private RuleGroupsNamespaceDescription ruleGroupsNamespace;

    /**
     * <p>
     * The selected rule groups namespace.
     * </p>
     * 
     * @param ruleGroupsNamespace
     *        The selected rule groups namespace.
     */

    public void setRuleGroupsNamespace(RuleGroupsNamespaceDescription ruleGroupsNamespace) {
        this.ruleGroupsNamespace = ruleGroupsNamespace;
    }

    /**
     * <p>
     * The selected rule groups namespace.
     * </p>
     * 
     * @return The selected rule groups namespace.
     */

    public RuleGroupsNamespaceDescription getRuleGroupsNamespace() {
        return this.ruleGroupsNamespace;
    }

    /**
     * <p>
     * The selected rule groups namespace.
     * </p>
     * 
     * @param ruleGroupsNamespace
     *        The selected rule groups namespace.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeRuleGroupsNamespaceResult withRuleGroupsNamespace(RuleGroupsNamespaceDescription ruleGroupsNamespace) {
        setRuleGroupsNamespace(ruleGroupsNamespace);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getRuleGroupsNamespace() != null)
            sb.append("RuleGroupsNamespace: ").append(getRuleGroupsNamespace());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof DescribeRuleGroupsNamespaceResult == false)
            return false;
        DescribeRuleGroupsNamespaceResult other = (DescribeRuleGroupsNamespaceResult) obj;
        if (other.getRuleGroupsNamespace() == null ^ this.getRuleGroupsNamespace() == null)
            return false;
        if (other.getRuleGroupsNamespace() != null && other.getRuleGroupsNamespace().equals(this.getRuleGroupsNamespace()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getRuleGroupsNamespace() == null) ? 0 : getRuleGroupsNamespace().hashCode());
        return hashCode;
    }

    @Override
    public DescribeRuleGroupsNamespaceResult clone() {
        try {
            return (DescribeRuleGroupsNamespaceResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
