/*
 * Copyright 2017-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.imagebuilder.model.transform;

import java.util.List;
import javax.annotation.Generated;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.imagebuilder.model.*;

import com.amazonaws.protocol.*;
import com.amazonaws.annotation.SdkInternalApi;

/**
 * LaunchPermissionConfigurationMarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
@SdkInternalApi
public class LaunchPermissionConfigurationMarshaller {

    private static final MarshallingInfo<List> USERIDS_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("userIds").build();
    private static final MarshallingInfo<List> USERGROUPS_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("userGroups").build();
    private static final MarshallingInfo<List> ORGANIZATIONARNS_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("organizationArns").build();
    private static final MarshallingInfo<List> ORGANIZATIONALUNITARNS_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("organizationalUnitArns").build();

    private static final LaunchPermissionConfigurationMarshaller instance = new LaunchPermissionConfigurationMarshaller();

    public static LaunchPermissionConfigurationMarshaller getInstance() {
        return instance;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(LaunchPermissionConfiguration launchPermissionConfiguration, ProtocolMarshaller protocolMarshaller) {

        if (launchPermissionConfiguration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {
            protocolMarshaller.marshall(launchPermissionConfiguration.getUserIds(), USERIDS_BINDING);
            protocolMarshaller.marshall(launchPermissionConfiguration.getUserGroups(), USERGROUPS_BINDING);
            protocolMarshaller.marshall(launchPermissionConfiguration.getOrganizationArns(), ORGANIZATIONARNS_BINDING);
            protocolMarshaller.marshall(launchPermissionConfiguration.getOrganizationalUnitArns(), ORGANIZATIONALUNITARNS_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
