/*
 * Copyright 2017-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.cloudwatchevidently;

import javax.annotation.Generated;

import com.amazonaws.services.cloudwatchevidently.model.*;

/**
 * Abstract implementation of {@code AmazonCloudWatchEvidentlyAsync}. Convenient method forms pass through to the
 * corresponding overload that takes a request object and an {@code AsyncHandler}, which throws an
 * {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAmazonCloudWatchEvidentlyAsync extends AbstractAmazonCloudWatchEvidently implements AmazonCloudWatchEvidentlyAsync {

    protected AbstractAmazonCloudWatchEvidentlyAsync() {
    }

    @Override
    public java.util.concurrent.Future<BatchEvaluateFeatureResult> batchEvaluateFeatureAsync(BatchEvaluateFeatureRequest request) {

        return batchEvaluateFeatureAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<BatchEvaluateFeatureResult> batchEvaluateFeatureAsync(BatchEvaluateFeatureRequest request,
            com.amazonaws.handlers.AsyncHandler<BatchEvaluateFeatureRequest, BatchEvaluateFeatureResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateExperimentResult> createExperimentAsync(CreateExperimentRequest request) {

        return createExperimentAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateExperimentResult> createExperimentAsync(CreateExperimentRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateExperimentRequest, CreateExperimentResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateFeatureResult> createFeatureAsync(CreateFeatureRequest request) {

        return createFeatureAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateFeatureResult> createFeatureAsync(CreateFeatureRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateFeatureRequest, CreateFeatureResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateLaunchResult> createLaunchAsync(CreateLaunchRequest request) {

        return createLaunchAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateLaunchResult> createLaunchAsync(CreateLaunchRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateLaunchRequest, CreateLaunchResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateProjectResult> createProjectAsync(CreateProjectRequest request) {

        return createProjectAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateProjectResult> createProjectAsync(CreateProjectRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateProjectRequest, CreateProjectResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateSegmentResult> createSegmentAsync(CreateSegmentRequest request) {

        return createSegmentAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateSegmentResult> createSegmentAsync(CreateSegmentRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateSegmentRequest, CreateSegmentResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteExperimentResult> deleteExperimentAsync(DeleteExperimentRequest request) {

        return deleteExperimentAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteExperimentResult> deleteExperimentAsync(DeleteExperimentRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteExperimentRequest, DeleteExperimentResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteFeatureResult> deleteFeatureAsync(DeleteFeatureRequest request) {

        return deleteFeatureAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteFeatureResult> deleteFeatureAsync(DeleteFeatureRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteFeatureRequest, DeleteFeatureResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteLaunchResult> deleteLaunchAsync(DeleteLaunchRequest request) {

        return deleteLaunchAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteLaunchResult> deleteLaunchAsync(DeleteLaunchRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteLaunchRequest, DeleteLaunchResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteProjectResult> deleteProjectAsync(DeleteProjectRequest request) {

        return deleteProjectAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteProjectResult> deleteProjectAsync(DeleteProjectRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteProjectRequest, DeleteProjectResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteSegmentResult> deleteSegmentAsync(DeleteSegmentRequest request) {

        return deleteSegmentAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteSegmentResult> deleteSegmentAsync(DeleteSegmentRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteSegmentRequest, DeleteSegmentResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<EvaluateFeatureResult> evaluateFeatureAsync(EvaluateFeatureRequest request) {

        return evaluateFeatureAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<EvaluateFeatureResult> evaluateFeatureAsync(EvaluateFeatureRequest request,
            com.amazonaws.handlers.AsyncHandler<EvaluateFeatureRequest, EvaluateFeatureResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetExperimentResult> getExperimentAsync(GetExperimentRequest request) {

        return getExperimentAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetExperimentResult> getExperimentAsync(GetExperimentRequest request,
            com.amazonaws.handlers.AsyncHandler<GetExperimentRequest, GetExperimentResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetExperimentResultsResult> getExperimentResultsAsync(GetExperimentResultsRequest request) {

        return getExperimentResultsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetExperimentResultsResult> getExperimentResultsAsync(GetExperimentResultsRequest request,
            com.amazonaws.handlers.AsyncHandler<GetExperimentResultsRequest, GetExperimentResultsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetFeatureResult> getFeatureAsync(GetFeatureRequest request) {

        return getFeatureAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetFeatureResult> getFeatureAsync(GetFeatureRequest request,
            com.amazonaws.handlers.AsyncHandler<GetFeatureRequest, GetFeatureResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetLaunchResult> getLaunchAsync(GetLaunchRequest request) {

        return getLaunchAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetLaunchResult> getLaunchAsync(GetLaunchRequest request,
            com.amazonaws.handlers.AsyncHandler<GetLaunchRequest, GetLaunchResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetProjectResult> getProjectAsync(GetProjectRequest request) {

        return getProjectAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetProjectResult> getProjectAsync(GetProjectRequest request,
            com.amazonaws.handlers.AsyncHandler<GetProjectRequest, GetProjectResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetSegmentResult> getSegmentAsync(GetSegmentRequest request) {

        return getSegmentAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetSegmentResult> getSegmentAsync(GetSegmentRequest request,
            com.amazonaws.handlers.AsyncHandler<GetSegmentRequest, GetSegmentResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListExperimentsResult> listExperimentsAsync(ListExperimentsRequest request) {

        return listExperimentsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListExperimentsResult> listExperimentsAsync(ListExperimentsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListExperimentsRequest, ListExperimentsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListFeaturesResult> listFeaturesAsync(ListFeaturesRequest request) {

        return listFeaturesAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListFeaturesResult> listFeaturesAsync(ListFeaturesRequest request,
            com.amazonaws.handlers.AsyncHandler<ListFeaturesRequest, ListFeaturesResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListLaunchesResult> listLaunchesAsync(ListLaunchesRequest request) {

        return listLaunchesAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListLaunchesResult> listLaunchesAsync(ListLaunchesRequest request,
            com.amazonaws.handlers.AsyncHandler<ListLaunchesRequest, ListLaunchesResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListProjectsResult> listProjectsAsync(ListProjectsRequest request) {

        return listProjectsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListProjectsResult> listProjectsAsync(ListProjectsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListProjectsRequest, ListProjectsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListSegmentReferencesResult> listSegmentReferencesAsync(ListSegmentReferencesRequest request) {

        return listSegmentReferencesAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListSegmentReferencesResult> listSegmentReferencesAsync(ListSegmentReferencesRequest request,
            com.amazonaws.handlers.AsyncHandler<ListSegmentReferencesRequest, ListSegmentReferencesResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListSegmentsResult> listSegmentsAsync(ListSegmentsRequest request) {

        return listSegmentsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListSegmentsResult> listSegmentsAsync(ListSegmentsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListSegmentsRequest, ListSegmentsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {

        return listTagsForResourceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request,
            com.amazonaws.handlers.AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<PutProjectEventsResult> putProjectEventsAsync(PutProjectEventsRequest request) {

        return putProjectEventsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<PutProjectEventsResult> putProjectEventsAsync(PutProjectEventsRequest request,
            com.amazonaws.handlers.AsyncHandler<PutProjectEventsRequest, PutProjectEventsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<StartExperimentResult> startExperimentAsync(StartExperimentRequest request) {

        return startExperimentAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<StartExperimentResult> startExperimentAsync(StartExperimentRequest request,
            com.amazonaws.handlers.AsyncHandler<StartExperimentRequest, StartExperimentResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<StartLaunchResult> startLaunchAsync(StartLaunchRequest request) {

        return startLaunchAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<StartLaunchResult> startLaunchAsync(StartLaunchRequest request,
            com.amazonaws.handlers.AsyncHandler<StartLaunchRequest, StartLaunchResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<StopExperimentResult> stopExperimentAsync(StopExperimentRequest request) {

        return stopExperimentAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<StopExperimentResult> stopExperimentAsync(StopExperimentRequest request,
            com.amazonaws.handlers.AsyncHandler<StopExperimentRequest, StopExperimentResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<StopLaunchResult> stopLaunchAsync(StopLaunchRequest request) {

        return stopLaunchAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<StopLaunchResult> stopLaunchAsync(StopLaunchRequest request,
            com.amazonaws.handlers.AsyncHandler<StopLaunchRequest, StopLaunchResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {

        return tagResourceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<TagResourceResult> tagResourceAsync(TagResourceRequest request,
            com.amazonaws.handlers.AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<TestSegmentPatternResult> testSegmentPatternAsync(TestSegmentPatternRequest request) {

        return testSegmentPatternAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<TestSegmentPatternResult> testSegmentPatternAsync(TestSegmentPatternRequest request,
            com.amazonaws.handlers.AsyncHandler<TestSegmentPatternRequest, TestSegmentPatternResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {

        return untagResourceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request,
            com.amazonaws.handlers.AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateExperimentResult> updateExperimentAsync(UpdateExperimentRequest request) {

        return updateExperimentAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateExperimentResult> updateExperimentAsync(UpdateExperimentRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateExperimentRequest, UpdateExperimentResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateFeatureResult> updateFeatureAsync(UpdateFeatureRequest request) {

        return updateFeatureAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateFeatureResult> updateFeatureAsync(UpdateFeatureRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateFeatureRequest, UpdateFeatureResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateLaunchResult> updateLaunchAsync(UpdateLaunchRequest request) {

        return updateLaunchAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateLaunchResult> updateLaunchAsync(UpdateLaunchRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateLaunchRequest, UpdateLaunchResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateProjectResult> updateProjectAsync(UpdateProjectRequest request) {

        return updateProjectAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateProjectResult> updateProjectAsync(UpdateProjectRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateProjectRequest, UpdateProjectResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateProjectDataDeliveryResult> updateProjectDataDeliveryAsync(UpdateProjectDataDeliveryRequest request) {

        return updateProjectDataDeliveryAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateProjectDataDeliveryResult> updateProjectDataDeliveryAsync(UpdateProjectDataDeliveryRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateProjectDataDeliveryRequest, UpdateProjectDataDeliveryResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

}
