/*
 * Copyright 2017-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.schemas.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/GetDiscoveredSchema" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class GetDiscoveredSchemaRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * An array of strings where each string is a JSON event. These are the events that were used to generate the
     * schema. The array includes a single type of event and has a maximum size of 10 events.
     * </p>
     */
    private java.util.List<String> events;
    /**
     * <p>
     * The type of event.
     * </p>
     */
    private String type;

    /**
     * <p>
     * An array of strings where each string is a JSON event. These are the events that were used to generate the
     * schema. The array includes a single type of event and has a maximum size of 10 events.
     * </p>
     * 
     * @return An array of strings where each string is a JSON event. These are the events that were used to generate
     *         the schema. The array includes a single type of event and has a maximum size of 10 events.
     */

    public java.util.List<String> getEvents() {
        return events;
    }

    /**
     * <p>
     * An array of strings where each string is a JSON event. These are the events that were used to generate the
     * schema. The array includes a single type of event and has a maximum size of 10 events.
     * </p>
     * 
     * @param events
     *        An array of strings where each string is a JSON event. These are the events that were used to generate the
     *        schema. The array includes a single type of event and has a maximum size of 10 events.
     */

    public void setEvents(java.util.Collection<String> events) {
        if (events == null) {
            this.events = null;
            return;
        }

        this.events = new java.util.ArrayList<String>(events);
    }

    /**
     * <p>
     * An array of strings where each string is a JSON event. These are the events that were used to generate the
     * schema. The array includes a single type of event and has a maximum size of 10 events.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setEvents(java.util.Collection)} or {@link #withEvents(java.util.Collection)} if you want to override the
     * existing values.
     * </p>
     * 
     * @param events
     *        An array of strings where each string is a JSON event. These are the events that were used to generate the
     *        schema. The array includes a single type of event and has a maximum size of 10 events.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GetDiscoveredSchemaRequest withEvents(String... events) {
        if (this.events == null) {
            setEvents(new java.util.ArrayList<String>(events.length));
        }
        for (String ele : events) {
            this.events.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * An array of strings where each string is a JSON event. These are the events that were used to generate the
     * schema. The array includes a single type of event and has a maximum size of 10 events.
     * </p>
     * 
     * @param events
     *        An array of strings where each string is a JSON event. These are the events that were used to generate the
     *        schema. The array includes a single type of event and has a maximum size of 10 events.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GetDiscoveredSchemaRequest withEvents(java.util.Collection<String> events) {
        setEvents(events);
        return this;
    }

    /**
     * <p>
     * The type of event.
     * </p>
     * 
     * @param type
     *        The type of event.
     * @see Type
     */

    public void setType(String type) {
        this.type = type;
    }

    /**
     * <p>
     * The type of event.
     * </p>
     * 
     * @return The type of event.
     * @see Type
     */

    public String getType() {
        return this.type;
    }

    /**
     * <p>
     * The type of event.
     * </p>
     * 
     * @param type
     *        The type of event.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see Type
     */

    public GetDiscoveredSchemaRequest withType(String type) {
        setType(type);
        return this;
    }

    /**
     * <p>
     * The type of event.
     * </p>
     * 
     * @param type
     *        The type of event.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see Type
     */

    public GetDiscoveredSchemaRequest withType(Type type) {
        this.type = type.toString();
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getEvents() != null)
            sb.append("Events: ").append(getEvents()).append(",");
        if (getType() != null)
            sb.append("Type: ").append(getType());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof GetDiscoveredSchemaRequest == false)
            return false;
        GetDiscoveredSchemaRequest other = (GetDiscoveredSchemaRequest) obj;
        if (other.getEvents() == null ^ this.getEvents() == null)
            return false;
        if (other.getEvents() != null && other.getEvents().equals(this.getEvents()) == false)
            return false;
        if (other.getType() == null ^ this.getType() == null)
            return false;
        if (other.getType() != null && other.getType().equals(this.getType()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getEvents() == null) ? 0 : getEvents().hashCode());
        hashCode = prime * hashCode + ((getType() == null) ? 0 : getType().hashCode());
        return hashCode;
    }

    @Override
    public GetDiscoveredSchemaRequest clone() {
        return (GetDiscoveredSchemaRequest) super.clone();
    }

}
