/*
 * Copyright 2017-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.gluedatabrew.model.transform;

import java.util.List;
import javax.annotation.Generated;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.gluedatabrew.model.*;

import com.amazonaws.protocol.*;
import com.amazonaws.annotation.SdkInternalApi;

/**
 * ViewFrameMarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
@SdkInternalApi
public class ViewFrameMarshaller {

    private static final MarshallingInfo<Integer> STARTCOLUMNINDEX_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StartColumnIndex").build();
    private static final MarshallingInfo<Integer> COLUMNRANGE_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ColumnRange").build();
    private static final MarshallingInfo<List> HIDDENCOLUMNS_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("HiddenColumns").build();
    private static final MarshallingInfo<Integer> STARTROWINDEX_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StartRowIndex").build();
    private static final MarshallingInfo<Integer> ROWRANGE_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RowRange").build();
    private static final MarshallingInfo<String> ANALYTICS_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("Analytics").build();

    private static final ViewFrameMarshaller instance = new ViewFrameMarshaller();

    public static ViewFrameMarshaller getInstance() {
        return instance;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(ViewFrame viewFrame, ProtocolMarshaller protocolMarshaller) {

        if (viewFrame == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {
            protocolMarshaller.marshall(viewFrame.getStartColumnIndex(), STARTCOLUMNINDEX_BINDING);
            protocolMarshaller.marshall(viewFrame.getColumnRange(), COLUMNRANGE_BINDING);
            protocolMarshaller.marshall(viewFrame.getHiddenColumns(), HIDDENCOLUMNS_BINDING);
            protocolMarshaller.marshall(viewFrame.getStartRowIndex(), STARTROWINDEX_BINDING);
            protocolMarshaller.marshall(viewFrame.getRowRange(), ROWRANGE_BINDING);
            protocolMarshaller.marshall(viewFrame.getAnalytics(), ANALYTICS_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
