/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.xray.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.xray.model.Alias;
import java.util.List;

public class AliasJsonMarshaller {
    private static AliasJsonMarshaller instance;

    public void marshall(Alias alias, StructuredJsonGenerator jsonGenerator) {
        if (alias == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<String> namesList;
            jsonGenerator.writeStartObject();
            if (alias.getName() != null) {
                jsonGenerator.writeFieldName("Name").writeValue(alias.getName());
            }
            if ((namesList = alias.getNames()) != null) {
                jsonGenerator.writeFieldName("Names");
                jsonGenerator.writeStartArray();
                for (String namesListValue : namesList) {
                    if (namesListValue == null) continue;
                    jsonGenerator.writeValue(namesListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (alias.getType() != null) {
                jsonGenerator.writeFieldName("Type").writeValue(alias.getType());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static AliasJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new AliasJsonMarshaller();
        }
        return instance;
    }
}

