/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.simplesystemsmanagement.model.DocumentIdentifier;

public class DocumentIdentifierJsonMarshaller {
    private static DocumentIdentifierJsonMarshaller instance;

    public void marshall(DocumentIdentifier documentIdentifier, StructuredJsonGenerator jsonGenerator) {
        if (documentIdentifier == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList platformTypesList;
            jsonGenerator.writeStartObject();
            if (documentIdentifier.getName() != null) {
                jsonGenerator.writeFieldName("Name").writeValue(documentIdentifier.getName());
            }
            if (documentIdentifier.getOwner() != null) {
                jsonGenerator.writeFieldName("Owner").writeValue(documentIdentifier.getOwner());
            }
            if (!(platformTypesList = (SdkInternalList)documentIdentifier.getPlatformTypes()).isEmpty() || !platformTypesList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("PlatformTypes");
                jsonGenerator.writeStartArray();
                for (String platformTypesListValue : platformTypesList) {
                    if (platformTypesListValue == null) continue;
                    jsonGenerator.writeValue(platformTypesListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (documentIdentifier.getDocumentVersion() != null) {
                jsonGenerator.writeFieldName("DocumentVersion").writeValue(documentIdentifier.getDocumentVersion());
            }
            if (documentIdentifier.getDocumentType() != null) {
                jsonGenerator.writeFieldName("DocumentType").writeValue(documentIdentifier.getDocumentType());
            }
            if (documentIdentifier.getSchemaVersion() != null) {
                jsonGenerator.writeFieldName("SchemaVersion").writeValue(documentIdentifier.getSchemaVersion());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static DocumentIdentifierJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new DocumentIdentifierJsonMarshaller();
        }
        return instance;
    }
}

