/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53domains.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.route53domains.model.CheckDomainAvailabilityRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class CheckDomainAvailabilityRequestMarshaller
implements Marshaller<Request<CheckDomainAvailabilityRequest>, CheckDomainAvailabilityRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public CheckDomainAvailabilityRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<CheckDomainAvailabilityRequest> marshall(CheckDomainAvailabilityRequest checkDomainAvailabilityRequest) {
        if (checkDomainAvailabilityRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CheckDomainAvailabilityRequest> request = new DefaultRequest<CheckDomainAvailabilityRequest>(checkDomainAvailabilityRequest, "AmazonRoute53Domains");
        request.addHeader("X-Amz-Target", "Route53Domains_v20140515.CheckDomainAvailability");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (checkDomainAvailabilityRequest.getDomainName() != null) {
                jsonGenerator.writeFieldName("DomainName").writeValue(checkDomainAvailabilityRequest.getDomainName());
            }
            if (checkDomainAvailabilityRequest.getIdnLangCode() != null) {
                jsonGenerator.writeFieldName("IdnLangCode").writeValue(checkDomainAvailabilityRequest.getIdnLangCode());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

