/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.pinpoint.model.SegmentResponse;
import com.amazonaws.services.pinpoint.model.transform.SegmentDimensionsJsonMarshaller;
import com.amazonaws.services.pinpoint.model.transform.SegmentImportResourceJsonMarshaller;

public class SegmentResponseJsonMarshaller {
    private static SegmentResponseJsonMarshaller instance;

    public void marshall(SegmentResponse segmentResponse, StructuredJsonGenerator jsonGenerator) {
        if (segmentResponse == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (segmentResponse.getApplicationId() != null) {
                jsonGenerator.writeFieldName("ApplicationId").writeValue(segmentResponse.getApplicationId());
            }
            if (segmentResponse.getCreationDate() != null) {
                jsonGenerator.writeFieldName("CreationDate").writeValue(segmentResponse.getCreationDate());
            }
            if (segmentResponse.getDimensions() != null) {
                jsonGenerator.writeFieldName("Dimensions");
                SegmentDimensionsJsonMarshaller.getInstance().marshall(segmentResponse.getDimensions(), jsonGenerator);
            }
            if (segmentResponse.getId() != null) {
                jsonGenerator.writeFieldName("Id").writeValue(segmentResponse.getId());
            }
            if (segmentResponse.getImportDefinition() != null) {
                jsonGenerator.writeFieldName("ImportDefinition");
                SegmentImportResourceJsonMarshaller.getInstance().marshall(segmentResponse.getImportDefinition(), jsonGenerator);
            }
            if (segmentResponse.getLastModifiedDate() != null) {
                jsonGenerator.writeFieldName("LastModifiedDate").writeValue(segmentResponse.getLastModifiedDate());
            }
            if (segmentResponse.getName() != null) {
                jsonGenerator.writeFieldName("Name").writeValue(segmentResponse.getName());
            }
            if (segmentResponse.getSegmentType() != null) {
                jsonGenerator.writeFieldName("SegmentType").writeValue(segmentResponse.getSegmentType());
            }
            if (segmentResponse.getVersion() != null) {
                jsonGenerator.writeFieldName("Version").writeValue(segmentResponse.getVersion());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static SegmentResponseJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new SegmentResponseJsonMarshaller();
        }
        return instance;
    }
}

