/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.pinpoint.model.AttributeDimension;
import com.amazonaws.services.pinpoint.model.SegmentDimensions;
import com.amazonaws.services.pinpoint.model.transform.AttributeDimensionJsonMarshaller;
import com.amazonaws.services.pinpoint.model.transform.SegmentBehaviorsJsonMarshaller;
import com.amazonaws.services.pinpoint.model.transform.SegmentDemographicsJsonMarshaller;
import com.amazonaws.services.pinpoint.model.transform.SegmentLocationJsonMarshaller;
import java.util.Map;

public class SegmentDimensionsJsonMarshaller {
    private static SegmentDimensionsJsonMarshaller instance;

    public void marshall(SegmentDimensions segmentDimensions, StructuredJsonGenerator jsonGenerator) {
        if (segmentDimensions == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            Map<String, AttributeDimension> attributesMap = segmentDimensions.getAttributes();
            if (attributesMap != null) {
                jsonGenerator.writeFieldName("Attributes");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, AttributeDimension> attributesMapValue : attributesMap.entrySet()) {
                    if (attributesMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName(attributesMapValue.getKey());
                    AttributeDimensionJsonMarshaller.getInstance().marshall(attributesMapValue.getValue(), jsonGenerator);
                }
                jsonGenerator.writeEndObject();
            }
            if (segmentDimensions.getBehavior() != null) {
                jsonGenerator.writeFieldName("Behavior");
                SegmentBehaviorsJsonMarshaller.getInstance().marshall(segmentDimensions.getBehavior(), jsonGenerator);
            }
            if (segmentDimensions.getDemographic() != null) {
                jsonGenerator.writeFieldName("Demographic");
                SegmentDemographicsJsonMarshaller.getInstance().marshall(segmentDimensions.getDemographic(), jsonGenerator);
            }
            if (segmentDimensions.getLocation() != null) {
                jsonGenerator.writeFieldName("Location");
                SegmentLocationJsonMarshaller.getInstance().marshall(segmentDimensions.getLocation(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static SegmentDimensionsJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new SegmentDimensionsJsonMarshaller();
        }
        return instance;
    }
}

