/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.services.pinpoint.model.GetImportJobRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.transform.PathMarshallers;
import java.io.ByteArrayInputStream;

public class GetImportJobRequestMarshaller
implements Marshaller<Request<GetImportJobRequest>, GetImportJobRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public GetImportJobRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<GetImportJobRequest> marshall(GetImportJobRequest getImportJobRequest) {
        if (getImportJobRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<GetImportJobRequest> request = new DefaultRequest<GetImportJobRequest>(getImportJobRequest, "AmazonPinpoint");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/v1/apps/{application-id}/jobs/import/{job-id}";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "application-id", getImportJobRequest.getApplicationId());
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "job-id", getImportJobRequest.getJobId());
        request.setResourcePath(uriResourcePath);
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

