/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lightsail.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.lightsail.model.Bundle;

public class BundleJsonMarshaller {
    private static BundleJsonMarshaller instance;

    public void marshall(Bundle bundle, StructuredJsonGenerator jsonGenerator) {
        if (bundle == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (bundle.getPrice() != null) {
                jsonGenerator.writeFieldName("price").writeValue(bundle.getPrice().floatValue());
            }
            if (bundle.getCpuCount() != null) {
                jsonGenerator.writeFieldName("cpuCount").writeValue(bundle.getCpuCount());
            }
            if (bundle.getDiskSizeInGb() != null) {
                jsonGenerator.writeFieldName("diskSizeInGb").writeValue(bundle.getDiskSizeInGb());
            }
            if (bundle.getBundleId() != null) {
                jsonGenerator.writeFieldName("bundleId").writeValue(bundle.getBundleId());
            }
            if (bundle.getInstanceType() != null) {
                jsonGenerator.writeFieldName("instanceType").writeValue(bundle.getInstanceType());
            }
            if (bundle.getIsActive() != null) {
                jsonGenerator.writeFieldName("isActive").writeValue(bundle.getIsActive());
            }
            if (bundle.getName() != null) {
                jsonGenerator.writeFieldName("name").writeValue(bundle.getName());
            }
            if (bundle.getPower() != null) {
                jsonGenerator.writeFieldName("power").writeValue(bundle.getPower());
            }
            if (bundle.getRamSizeInGb() != null) {
                jsonGenerator.writeFieldName("ramSizeInGb").writeValue(bundle.getRamSizeInGb().floatValue());
            }
            if (bundle.getTransferPerMonthInGb() != null) {
                jsonGenerator.writeFieldName("transferPerMonthInGb").writeValue(bundle.getTransferPerMonthInGb());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static BundleJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new BundleJsonMarshaller();
        }
        return instance;
    }
}

