/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticfilesystem.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.services.elasticfilesystem.model.DeleteMountTargetRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.transform.PathMarshallers;
import java.io.ByteArrayInputStream;

public class DeleteMountTargetRequestMarshaller
implements Marshaller<Request<DeleteMountTargetRequest>, DeleteMountTargetRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public DeleteMountTargetRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<DeleteMountTargetRequest> marshall(DeleteMountTargetRequest deleteMountTargetRequest) {
        if (deleteMountTargetRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DeleteMountTargetRequest> request = new DefaultRequest<DeleteMountTargetRequest>(deleteMountTargetRequest, "AmazonElasticFileSystem");
        request.setHttpMethod(HttpMethodName.DELETE);
        String uriResourcePath = "/2015-02-01/mount-targets/{MountTargetId}";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "MountTargetId", deleteMountTargetRequest.getMountTargetId());
        request.setResourcePath(uriResourcePath);
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

