/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.datapipeline.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.datapipeline.model.EvaluateExpressionRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class EvaluateExpressionRequestMarshaller
implements Marshaller<Request<EvaluateExpressionRequest>, EvaluateExpressionRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public EvaluateExpressionRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<EvaluateExpressionRequest> marshall(EvaluateExpressionRequest evaluateExpressionRequest) {
        if (evaluateExpressionRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<EvaluateExpressionRequest> request = new DefaultRequest<EvaluateExpressionRequest>(evaluateExpressionRequest, "DataPipeline");
        request.addHeader("X-Amz-Target", "DataPipeline.EvaluateExpression");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (evaluateExpressionRequest.getPipelineId() != null) {
                jsonGenerator.writeFieldName("pipelineId").writeValue(evaluateExpressionRequest.getPipelineId());
            }
            if (evaluateExpressionRequest.getObjectId() != null) {
                jsonGenerator.writeFieldName("objectId").writeValue(evaluateExpressionRequest.getObjectId());
            }
            if (evaluateExpressionRequest.getExpression() != null) {
                jsonGenerator.writeFieldName("expression").writeValue(evaluateExpressionRequest.getExpression());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

