/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidp.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.cognitoidp.model.AdminRespondToAuthChallengeRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.util.Map;

public class AdminRespondToAuthChallengeRequestMarshaller
implements Marshaller<Request<AdminRespondToAuthChallengeRequest>, AdminRespondToAuthChallengeRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public AdminRespondToAuthChallengeRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<AdminRespondToAuthChallengeRequest> marshall(AdminRespondToAuthChallengeRequest adminRespondToAuthChallengeRequest) {
        if (adminRespondToAuthChallengeRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<AdminRespondToAuthChallengeRequest> request = new DefaultRequest<AdminRespondToAuthChallengeRequest>(adminRespondToAuthChallengeRequest, "AWSCognitoIdentityProvider");
        request.addHeader("X-Amz-Target", "AWSCognitoIdentityProviderService.AdminRespondToAuthChallenge");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            Map<String, String> challengeResponsesMap;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (adminRespondToAuthChallengeRequest.getUserPoolId() != null) {
                jsonGenerator.writeFieldName("UserPoolId").writeValue(adminRespondToAuthChallengeRequest.getUserPoolId());
            }
            if (adminRespondToAuthChallengeRequest.getClientId() != null) {
                jsonGenerator.writeFieldName("ClientId").writeValue(adminRespondToAuthChallengeRequest.getClientId());
            }
            if (adminRespondToAuthChallengeRequest.getChallengeName() != null) {
                jsonGenerator.writeFieldName("ChallengeName").writeValue(adminRespondToAuthChallengeRequest.getChallengeName());
            }
            if ((challengeResponsesMap = adminRespondToAuthChallengeRequest.getChallengeResponses()) != null) {
                jsonGenerator.writeFieldName("ChallengeResponses");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, String> challengeResponsesMapValue : challengeResponsesMap.entrySet()) {
                    if (challengeResponsesMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName(challengeResponsesMapValue.getKey());
                    jsonGenerator.writeValue(challengeResponsesMapValue.getValue());
                }
                jsonGenerator.writeEndObject();
            }
            if (adminRespondToAuthChallengeRequest.getSession() != null) {
                jsonGenerator.writeFieldName("Session").writeValue(adminRespondToAuthChallengeRequest.getSession());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

