/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.batch.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.batch.model.JobDependency;
import com.amazonaws.services.batch.model.JobDetail;
import com.amazonaws.services.batch.model.transform.ContainerDetailJsonMarshaller;
import com.amazonaws.services.batch.model.transform.JobDependencyJsonMarshaller;
import java.util.List;
import java.util.Map;

public class JobDetailJsonMarshaller {
    private static JobDetailJsonMarshaller instance;

    public void marshall(JobDetail jobDetail, StructuredJsonGenerator jsonGenerator) {
        if (jobDetail == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            Map<String, String> parametersMap;
            List<JobDependency> dependsOnList;
            jsonGenerator.writeStartObject();
            if (jobDetail.getJobName() != null) {
                jsonGenerator.writeFieldName("jobName").writeValue(jobDetail.getJobName());
            }
            if (jobDetail.getJobId() != null) {
                jsonGenerator.writeFieldName("jobId").writeValue(jobDetail.getJobId());
            }
            if (jobDetail.getJobQueue() != null) {
                jsonGenerator.writeFieldName("jobQueue").writeValue(jobDetail.getJobQueue());
            }
            if (jobDetail.getStatus() != null) {
                jsonGenerator.writeFieldName("status").writeValue(jobDetail.getStatus());
            }
            if (jobDetail.getStatusReason() != null) {
                jsonGenerator.writeFieldName("statusReason").writeValue(jobDetail.getStatusReason());
            }
            if (jobDetail.getCreatedAt() != null) {
                jsonGenerator.writeFieldName("createdAt").writeValue(jobDetail.getCreatedAt());
            }
            if (jobDetail.getStartedAt() != null) {
                jsonGenerator.writeFieldName("startedAt").writeValue(jobDetail.getStartedAt());
            }
            if (jobDetail.getStoppedAt() != null) {
                jsonGenerator.writeFieldName("stoppedAt").writeValue(jobDetail.getStoppedAt());
            }
            if ((dependsOnList = jobDetail.getDependsOn()) != null) {
                jsonGenerator.writeFieldName("dependsOn");
                jsonGenerator.writeStartArray();
                for (JobDependency dependsOnListValue : dependsOnList) {
                    if (dependsOnListValue == null) continue;
                    JobDependencyJsonMarshaller.getInstance().marshall(dependsOnListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (jobDetail.getJobDefinition() != null) {
                jsonGenerator.writeFieldName("jobDefinition").writeValue(jobDetail.getJobDefinition());
            }
            if ((parametersMap = jobDetail.getParameters()) != null) {
                jsonGenerator.writeFieldName("parameters");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, String> parametersMapValue : parametersMap.entrySet()) {
                    if (parametersMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName(parametersMapValue.getKey());
                    jsonGenerator.writeValue(parametersMapValue.getValue());
                }
                jsonGenerator.writeEndObject();
            }
            if (jobDetail.getContainer() != null) {
                jsonGenerator.writeFieldName("container");
                ContainerDetailJsonMarshaller.getInstance().marshall(jobDetail.getContainer(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static JobDetailJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new JobDetailJsonMarshaller();
        }
        return instance;
    }
}

