/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.apigateway.model.RestApi;
import java.util.List;

public class RestApiJsonMarshaller {
    private static RestApiJsonMarshaller instance;

    public void marshall(RestApi restApi, StructuredJsonGenerator jsonGenerator) {
        if (restApi == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<String> binaryMediaTypesList;
            List<String> warningsList;
            jsonGenerator.writeStartObject();
            if (restApi.getId() != null) {
                jsonGenerator.writeFieldName("id").writeValue(restApi.getId());
            }
            if (restApi.getName() != null) {
                jsonGenerator.writeFieldName("name").writeValue(restApi.getName());
            }
            if (restApi.getDescription() != null) {
                jsonGenerator.writeFieldName("description").writeValue(restApi.getDescription());
            }
            if (restApi.getCreatedDate() != null) {
                jsonGenerator.writeFieldName("createdDate").writeValue(restApi.getCreatedDate());
            }
            if (restApi.getVersion() != null) {
                jsonGenerator.writeFieldName("version").writeValue(restApi.getVersion());
            }
            if ((warningsList = restApi.getWarnings()) != null) {
                jsonGenerator.writeFieldName("warnings");
                jsonGenerator.writeStartArray();
                for (String warningsListValue : warningsList) {
                    if (warningsListValue == null) continue;
                    jsonGenerator.writeValue(warningsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if ((binaryMediaTypesList = restApi.getBinaryMediaTypes()) != null) {
                jsonGenerator.writeFieldName("binaryMediaTypes");
                jsonGenerator.writeStartArray();
                for (String binaryMediaTypesListValue : binaryMediaTypesList) {
                    if (binaryMediaTypesListValue == null) continue;
                    jsonGenerator.writeValue(binaryMediaTypesListValue);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static RestApiJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new RestApiJsonMarshaller();
        }
        return instance;
    }
}

