/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.services.apigateway.model.GetDocumentationVersionsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.transform.PathMarshallers;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class GetDocumentationVersionsRequestMarshaller
implements Marshaller<Request<GetDocumentationVersionsRequest>, GetDocumentationVersionsRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public GetDocumentationVersionsRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<GetDocumentationVersionsRequest> marshall(GetDocumentationVersionsRequest getDocumentationVersionsRequest) {
        if (getDocumentationVersionsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<GetDocumentationVersionsRequest> request = new DefaultRequest<GetDocumentationVersionsRequest>(getDocumentationVersionsRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/restapis/{restapi_id}/documentation/versions";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "restapi_id", getDocumentationVersionsRequest.getRestApiId());
        request.setResourcePath(uriResourcePath);
        if (getDocumentationVersionsRequest.getPosition() != null) {
            request.addParameter("position", StringUtils.fromString(getDocumentationVersionsRequest.getPosition()));
        }
        if (getDocumentationVersionsRequest.getLimit() != null) {
            request.addParameter("limit", StringUtils.fromInteger(getDocumentationVersionsRequest.getLimit()));
        }
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

