/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.metrics.internal.cloudwatch;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.metrics.internal.cloudwatch.spi.AWSMetricTransformerFactory;
import com.amazonaws.metrics.internal.cloudwatch.spi.Dimensions;
import com.amazonaws.metrics.internal.cloudwatch.spi.MetricData;
import com.amazonaws.metrics.internal.cloudwatch.spi.RequestMetricTransformer;
import com.amazonaws.services.cloudwatch.model.Dimension;
import com.amazonaws.services.cloudwatch.model.MetricDatum;
import com.amazonaws.services.cloudwatch.model.StandardUnit;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.TimingInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.annotation.ThreadSafe;

@ThreadSafe
public class PredefinedMetricTransformer {
    private static final Log log = LogFactory.getLog(PredefinedMetricTransformer.class);
    static final boolean INCLUDE_REQUEST_TYPE = true;
    static final boolean EXCLUDE_REQUEST_TYPE = false;

    public List<MetricDatum> toMetricData(MetricType metricType, Request<?> request, Response<?> response) {
        if (metricType instanceof AWSRequestMetrics.Field) {
            AWSRequestMetrics.Field predefined = (AWSRequestMetrics.Field)metricType;
            switch (predefined) {
                case HttpClientRetryCount: 
                case HttpClientPoolAvailableCount: 
                case HttpClientPoolLeasedCount: 
                case HttpClientPoolPendingCount: {
                    return this.metricOfCount(predefined, request, response);
                }
                case RequestCount: 
                case RetryCount: {
                    return this.metricOfRequestOrRetryCount(predefined, request, response);
                }
                case ThrottledRetryCount: 
                case RetryCapacityConsumed: {
                    return this.counterMetricOf(predefined, request, response, false);
                }
                case ResponseProcessingTime: 
                case RequestSigningTime: {
                    return this.latencyMetricOf(predefined, request, response, false);
                }
                case ClientExecuteTime: {
                    return this.latencyOfClientExecuteTime(request, response);
                }
                case HttpClientSendRequestTime: 
                case HttpClientReceiveResponseTime: 
                case HttpRequestTime: 
                case HttpSocketReadTime: {
                    return this.latencyMetricOf(predefined, request, response, true);
                }
                case Exception: 
                case ThrottleException: {
                    return this.counterMetricOf(predefined, request, response, true);
                }
            }
        }
        for (AWSMetricTransformerFactory aws : AWSMetricTransformerFactory.values()) {
            if (!metricType.name().startsWith(aws.name())) continue;
            List<MetricDatum> metricData = aws.getRequestMetricTransformer().toMetricData(metricType, request, response);
            if (metricData == null) break;
            return metricData;
        }
        if (log.isDebugEnabled()) {
            AmazonWebServiceRequest origReq = request == null ? null : request.getOriginalRequest();
            String reqClassName = origReq == null ? null : origReq.getClass().getName();
            log.debug((Object)("No request metric transformer can be found for metric type " + metricType.name() + " for " + reqClassName));
        }
        return Collections.emptyList();
    }

    protected List<MetricDatum> metricOfRequestOrRetryCount(AWSRequestMetrics.Field metricType, Request<?> req, Object resp) {
        double count;
        AWSRequestMetrics m = req.getAWSRequestMetrics();
        TimingInfo ti = m.getTimingInfo();
        Number counter = ti.getCounter(AWSRequestMetrics.Field.RequestCount.name());
        if (counter == null) {
            return Collections.emptyList();
        }
        int requestCount = counter.intValue();
        if (requestCount < 1) {
            LogFactory.getLog(this.getClass()).debug((Object)"request count must be at least one");
            return Collections.emptyList();
        }
        double d = count = metricType == AWSRequestMetrics.Field.RequestCount ? (double)requestCount : (double)(requestCount - 1);
        if (count < 1.0) {
            return Collections.emptyList();
        }
        return Collections.singletonList(new MetricDatum().withMetricName(req.getServiceName()).withDimensions(new Dimension().withName(Dimensions.MetricType.name()).withValue(metricType.name())).withUnit(StandardUnit.Count).withValue(count).withTimestamp(RequestMetricTransformer.Utils.endTimestamp(ti)));
    }

    protected List<MetricDatum> metricOfCount(AWSRequestMetrics.Field metricType, Request<?> req, Object resp) {
        AWSRequestMetrics m = req.getAWSRequestMetrics();
        TimingInfo ti = m.getTimingInfo();
        Number counter = ti.getCounter(metricType.name());
        if (counter == null) {
            return Collections.emptyList();
        }
        double count = counter.doubleValue();
        if (count < 1.0) {
            return Collections.emptyList();
        }
        return Collections.singletonList(new MetricDatum().withMetricName(req.getServiceName()).withDimensions(new Dimension().withName(Dimensions.MetricType.name()).withValue(metricType.name())).withUnit(StandardUnit.Count).withValue(count).withTimestamp(RequestMetricTransformer.Utils.endTimestamp(ti)));
    }

    protected List<MetricDatum> latencyMetricOf(MetricType metricType, Request<?> req, Object response, boolean includesRequestType) {
        String metricName;
        AWSRequestMetrics m = req.getAWSRequestMetrics();
        TimingInfo root = m.getTimingInfo();
        List<TimingInfo> subMeasures = root.getAllSubMeasurements(metricName = metricType.name());
        if (subMeasures != null) {
            ArrayList<MetricDatum> result = new ArrayList<MetricDatum>(subMeasures.size());
            for (TimingInfo sub : subMeasures) {
                if (!sub.isEndTimeKnown()) continue;
                ArrayList<Dimension> dims = new ArrayList<Dimension>();
                dims.add(new Dimension().withName(Dimensions.MetricType.name()).withValue(metricName));
                if (includesRequestType) {
                    dims.add(new Dimension().withName(Dimensions.RequestType.name()).withValue(this.requestType(req)));
                }
                MetricDatum datum = new MetricDatum().withMetricName(req.getServiceName()).withDimensions(dims).withUnit(StandardUnit.Milliseconds).withValue(sub.getTimeTakenMillisIfKnown());
                result.add(datum);
            }
            return result;
        }
        return Collections.emptyList();
    }

    protected List<MetricDatum> latencyOfClientExecuteTime(Request<?> req, Object response) {
        AWSRequestMetrics m = req.getAWSRequestMetrics();
        TimingInfo root = m.getTimingInfo();
        String metricName = AWSRequestMetrics.Field.ClientExecuteTime.name();
        if (root.isEndTimeKnown()) {
            ArrayList<Dimension> dims = new ArrayList<Dimension>();
            dims.add(new Dimension().withName(Dimensions.MetricType.name()).withValue(metricName));
            dims.add(new Dimension().withName(Dimensions.RequestType.name()).withValue(this.requestType(req)));
            MetricDatum datum = new MetricDatum().withMetricName(req.getServiceName()).withDimensions(dims).withUnit(StandardUnit.Milliseconds).withValue(root.getTimeTakenMillisIfKnown());
            return Collections.singletonList(datum);
        }
        return Collections.emptyList();
    }

    private String requestType(Request<?> req) {
        return req.getOriginalRequest().getClass().getSimpleName();
    }

    protected List<MetricDatum> counterMetricOf(MetricType type, Request<?> req, Object resp, boolean includesRequestType) {
        String metricName;
        AWSRequestMetrics m = req.getAWSRequestMetrics();
        TimingInfo ti = m.getTimingInfo();
        Number counter = ti.getCounter(metricName = type.name());
        if (counter == null) {
            return Collections.emptyList();
        }
        int count = counter.intValue();
        if (count < 1) {
            LogFactory.getLog(this.getClass()).debug((Object)"Count must be at least one");
            return Collections.emptyList();
        }
        ArrayList<MetricDatum> result = new ArrayList<MetricDatum>();
        Dimension metricDimension = new Dimension().withName(Dimensions.MetricType.name()).withValue(metricName);
        MetricDatum first = new MetricDatum().withMetricName(req.getServiceName()).withDimensions(metricDimension).withUnit(StandardUnit.Count).withValue(Double.valueOf(count)).withTimestamp(RequestMetricTransformer.Utils.endTimestamp(ti));
        result.add(first);
        if (includesRequestType) {
            Dimension requestDimension = new Dimension().withName(Dimensions.RequestType.name()).withValue(this.requestType(req));
            MetricDatum second = MetricData.newMetricDatum(first, metricDimension, requestDimension);
            result.add(second);
        }
        return result;
    }
}

