/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.xray.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.xray.model.Edge;
import com.amazonaws.services.xray.model.HistogramEntry;
import com.amazonaws.services.xray.model.Service;
import com.amazonaws.services.xray.model.transform.EdgeJsonMarshaller;
import com.amazonaws.services.xray.model.transform.HistogramEntryJsonMarshaller;
import com.amazonaws.services.xray.model.transform.ServiceStatisticsJsonMarshaller;
import java.util.List;

public class ServiceJsonMarshaller {
    private static ServiceJsonMarshaller instance;

    public void marshall(Service service, StructuredJsonGenerator jsonGenerator) {
        if (service == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<HistogramEntry> list;
            List<Edge> edgesList;
            List<String> namesList;
            jsonGenerator.writeStartObject();
            if (service.getReferenceId() != null) {
                jsonGenerator.writeFieldName("ReferenceId").writeValue(service.getReferenceId());
            }
            if (service.getName() != null) {
                jsonGenerator.writeFieldName("Name").writeValue(service.getName());
            }
            if ((namesList = service.getNames()) != null) {
                jsonGenerator.writeFieldName("Names");
                jsonGenerator.writeStartArray();
                for (String string : namesList) {
                    if (string == null) continue;
                    jsonGenerator.writeValue(string);
                }
                jsonGenerator.writeEndArray();
            }
            if (service.getRoot() != null) {
                jsonGenerator.writeFieldName("Root").writeValue(service.getRoot());
            }
            if (service.getAccountId() != null) {
                jsonGenerator.writeFieldName("AccountId").writeValue(service.getAccountId());
            }
            if (service.getType() != null) {
                jsonGenerator.writeFieldName("Type").writeValue(service.getType());
            }
            if (service.getState() != null) {
                jsonGenerator.writeFieldName("State").writeValue(service.getState());
            }
            if (service.getStartTime() != null) {
                jsonGenerator.writeFieldName("StartTime").writeValue(service.getStartTime());
            }
            if (service.getEndTime() != null) {
                jsonGenerator.writeFieldName("EndTime").writeValue(service.getEndTime());
            }
            if ((edgesList = service.getEdges()) != null) {
                jsonGenerator.writeFieldName("Edges");
                jsonGenerator.writeStartArray();
                for (Edge edgesListValue : edgesList) {
                    if (edgesListValue == null) continue;
                    EdgeJsonMarshaller.getInstance().marshall(edgesListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (service.getSummaryStatistics() != null) {
                jsonGenerator.writeFieldName("SummaryStatistics");
                ServiceStatisticsJsonMarshaller.getInstance().marshall(service.getSummaryStatistics(), jsonGenerator);
            }
            if ((list = service.getDurationHistogram()) != null) {
                jsonGenerator.writeFieldName("DurationHistogram");
                jsonGenerator.writeStartArray();
                for (HistogramEntry durationHistogramListValue : list) {
                    if (durationHistogramListValue == null) continue;
                    HistogramEntryJsonMarshaller.getInstance().marshall(durationHistogramListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ServiceJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ServiceJsonMarshaller();
        }
        return instance;
    }
}

