/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.stepfunctions.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.stepfunctions.model.GetActivityTaskRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class GetActivityTaskRequestMarshaller
implements Marshaller<Request<GetActivityTaskRequest>, GetActivityTaskRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public GetActivityTaskRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<GetActivityTaskRequest> marshall(GetActivityTaskRequest getActivityTaskRequest) {
        if (getActivityTaskRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<GetActivityTaskRequest> request = new DefaultRequest<GetActivityTaskRequest>(getActivityTaskRequest, "AWSStepFunctions");
        request.addHeader("X-Amz-Target", "AWSStepFunctions.GetActivityTask");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (getActivityTaskRequest.getActivityArn() != null) {
                jsonGenerator.writeFieldName("activityArn").writeValue(getActivityTaskRequest.getActivityArn());
            }
            if (getActivityTaskRequest.getWorkerName() != null) {
                jsonGenerator.writeFieldName("workerName").writeValue(getActivityTaskRequest.getWorkerName());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

