/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.stepfunctions.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.stepfunctions.model.CreateActivityRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class CreateActivityRequestMarshaller
implements Marshaller<Request<CreateActivityRequest>, CreateActivityRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public CreateActivityRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<CreateActivityRequest> marshall(CreateActivityRequest createActivityRequest) {
        if (createActivityRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateActivityRequest> request = new DefaultRequest<CreateActivityRequest>(createActivityRequest, "AWSStepFunctions");
        request.addHeader("X-Amz-Target", "AWSStepFunctions.CreateActivity");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (createActivityRequest.getName() != null) {
                jsonGenerator.writeFieldName("name").writeValue(createActivityRequest.getName());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

