/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.snowball.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.snowball.model.Notification;
import java.util.List;

public class NotificationJsonMarshaller {
    private static NotificationJsonMarshaller instance;

    public void marshall(Notification notification, StructuredJsonGenerator jsonGenerator) {
        if (notification == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<String> jobStatesToNotifyList;
            jsonGenerator.writeStartObject();
            if (notification.getSnsTopicARN() != null) {
                jsonGenerator.writeFieldName("SnsTopicARN").writeValue(notification.getSnsTopicARN());
            }
            if ((jobStatesToNotifyList = notification.getJobStatesToNotify()) != null) {
                jsonGenerator.writeFieldName("JobStatesToNotify");
                jsonGenerator.writeStartArray();
                for (String jobStatesToNotifyListValue : jobStatesToNotifyList) {
                    if (jobStatesToNotifyListValue == null) continue;
                    jsonGenerator.writeValue(jobStatesToNotifyListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (notification.getNotifyAll() != null) {
                jsonGenerator.writeFieldName("NotifyAll").writeValue(notification.getNotifyAll());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static NotificationJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new NotificationJsonMarshaller();
        }
        return instance;
    }
}

