/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rekognition.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.rekognition.model.IndexFacesRequest;
import com.amazonaws.services.rekognition.model.transform.ImageJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.util.List;

public class IndexFacesRequestMarshaller
implements Marshaller<Request<IndexFacesRequest>, IndexFacesRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public IndexFacesRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<IndexFacesRequest> marshall(IndexFacesRequest indexFacesRequest) {
        if (indexFacesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<IndexFacesRequest> request = new DefaultRequest<IndexFacesRequest>(indexFacesRequest, "AmazonRekognition");
        request.addHeader("X-Amz-Target", "RekognitionService.IndexFaces");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            List<String> detectionAttributesList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (indexFacesRequest.getCollectionId() != null) {
                jsonGenerator.writeFieldName("CollectionId").writeValue(indexFacesRequest.getCollectionId());
            }
            if (indexFacesRequest.getImage() != null) {
                jsonGenerator.writeFieldName("Image");
                ImageJsonMarshaller.getInstance().marshall(indexFacesRequest.getImage(), jsonGenerator);
            }
            if (indexFacesRequest.getExternalImageId() != null) {
                jsonGenerator.writeFieldName("ExternalImageId").writeValue(indexFacesRequest.getExternalImageId());
            }
            if ((detectionAttributesList = indexFacesRequest.getDetectionAttributes()) != null) {
                jsonGenerator.writeFieldName("DetectionAttributes");
                jsonGenerator.writeStartArray();
                for (String detectionAttributesListValue : detectionAttributesList) {
                    if (detectionAttributesListValue == null) continue;
                    jsonGenerator.writeValue(detectionAttributesListValue);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

