/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.pinpoint.model.GetImportJobsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class GetImportJobsRequestMarshaller
implements Marshaller<Request<GetImportJobsRequest>, GetImportJobsRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public GetImportJobsRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<GetImportJobsRequest> marshall(GetImportJobsRequest getImportJobsRequest) {
        if (getImportJobsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<GetImportJobsRequest> request = new DefaultRequest<GetImportJobsRequest>(getImportJobsRequest, "AmazonPinpoint");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/v1/apps/{application-id}/jobs/import";
        uriResourcePath = uriResourcePath.replace("{application-id}", getImportJobsRequest.getApplicationId() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(getImportJobsRequest.getApplicationId()), false) : "");
        request.setResourcePath(uriResourcePath);
        if (getImportJobsRequest.getPageSize() != null) {
            request.addParameter("page-size", StringUtils.fromString(getImportJobsRequest.getPageSize()));
        }
        if (getImportJobsRequest.getToken() != null) {
            request.addParameter("token", StringUtils.fromString(getImportJobsRequest.getToken()));
        }
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

