/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.marketplacemetering.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.marketplacemetering.model.UsageRecord;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class BatchMeterUsageRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private List<UsageRecord> usageRecords;
    private String productCode;

    public List<UsageRecord> getUsageRecords() {
        return this.usageRecords;
    }

    public void setUsageRecords(Collection<UsageRecord> usageRecords) {
        if (usageRecords == null) {
            this.usageRecords = null;
            return;
        }
        this.usageRecords = new ArrayList<UsageRecord>(usageRecords);
    }

    public BatchMeterUsageRequest withUsageRecords(UsageRecord ... usageRecords) {
        if (this.usageRecords == null) {
            this.setUsageRecords(new ArrayList<UsageRecord>(usageRecords.length));
        }
        for (UsageRecord ele : usageRecords) {
            this.usageRecords.add(ele);
        }
        return this;
    }

    public BatchMeterUsageRequest withUsageRecords(Collection<UsageRecord> usageRecords) {
        this.setUsageRecords(usageRecords);
        return this;
    }

    public void setProductCode(String productCode) {
        this.productCode = productCode;
    }

    public String getProductCode() {
        return this.productCode;
    }

    public BatchMeterUsageRequest withProductCode(String productCode) {
        this.setProductCode(productCode);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getUsageRecords() != null) {
            sb.append("UsageRecords: " + this.getUsageRecords() + ",");
        }
        if (this.getProductCode() != null) {
            sb.append("ProductCode: " + this.getProductCode());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchMeterUsageRequest)) {
            return false;
        }
        BatchMeterUsageRequest other = (BatchMeterUsageRequest)obj;
        if (other.getUsageRecords() == null ^ this.getUsageRecords() == null) {
            return false;
        }
        if (other.getUsageRecords() != null && !other.getUsageRecords().equals(this.getUsageRecords())) {
            return false;
        }
        if (other.getProductCode() == null ^ this.getProductCode() == null) {
            return false;
        }
        return other.getProductCode() == null || other.getProductCode().equals(this.getProductCode());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getUsageRecords() == null ? 0 : this.getUsageRecords().hashCode());
        hashCode = 31 * hashCode + (this.getProductCode() == null ? 0 : this.getProductCode().hashCode());
        return hashCode;
    }

    @Override
    public BatchMeterUsageRequest clone() {
        return (BatchMeterUsageRequest)super.clone();
    }
}

