/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.machinelearning.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.machinelearning.model.DataSource;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class DescribeDataSourcesResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private SdkInternalList<DataSource> results;
    private String nextToken;

    public List<DataSource> getResults() {
        if (this.results == null) {
            this.results = new SdkInternalList();
        }
        return this.results;
    }

    public void setResults(Collection<DataSource> results) {
        if (results == null) {
            this.results = null;
            return;
        }
        this.results = new SdkInternalList<DataSource>(results);
    }

    public DescribeDataSourcesResult withResults(DataSource ... results) {
        if (this.results == null) {
            this.setResults(new SdkInternalList<DataSource>(results.length));
        }
        for (DataSource ele : results) {
            this.results.add(ele);
        }
        return this;
    }

    public DescribeDataSourcesResult withResults(Collection<DataSource> results) {
        this.setResults(results);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public DescribeDataSourcesResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getResults() != null) {
            sb.append("Results: " + this.getResults() + ",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: " + this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDataSourcesResult)) {
            return false;
        }
        DescribeDataSourcesResult other = (DescribeDataSourcesResult)obj;
        if (other.getResults() == null ^ this.getResults() == null) {
            return false;
        }
        if (other.getResults() != null && !other.getResults().equals(this.getResults())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getResults() == null ? 0 : this.getResults().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public DescribeDataSourcesResult clone() {
        try {
            return (DescribeDataSourcesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

