/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lightsail.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.lightsail.model.InstanceSnapshot;
import com.amazonaws.services.lightsail.model.transform.ResourceLocationJsonMarshaller;

public class InstanceSnapshotJsonMarshaller {
    private static InstanceSnapshotJsonMarshaller instance;

    public void marshall(InstanceSnapshot instanceSnapshot, StructuredJsonGenerator jsonGenerator) {
        if (instanceSnapshot == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (instanceSnapshot.getName() != null) {
                jsonGenerator.writeFieldName("name").writeValue(instanceSnapshot.getName());
            }
            if (instanceSnapshot.getArn() != null) {
                jsonGenerator.writeFieldName("arn").writeValue(instanceSnapshot.getArn());
            }
            if (instanceSnapshot.getSupportCode() != null) {
                jsonGenerator.writeFieldName("supportCode").writeValue(instanceSnapshot.getSupportCode());
            }
            if (instanceSnapshot.getCreatedAt() != null) {
                jsonGenerator.writeFieldName("createdAt").writeValue(instanceSnapshot.getCreatedAt());
            }
            if (instanceSnapshot.getLocation() != null) {
                jsonGenerator.writeFieldName("location");
                ResourceLocationJsonMarshaller.getInstance().marshall(instanceSnapshot.getLocation(), jsonGenerator);
            }
            if (instanceSnapshot.getResourceType() != null) {
                jsonGenerator.writeFieldName("resourceType").writeValue(instanceSnapshot.getResourceType());
            }
            if (instanceSnapshot.getState() != null) {
                jsonGenerator.writeFieldName("state").writeValue(instanceSnapshot.getState());
            }
            if (instanceSnapshot.getProgress() != null) {
                jsonGenerator.writeFieldName("progress").writeValue(instanceSnapshot.getProgress());
            }
            if (instanceSnapshot.getFromInstanceName() != null) {
                jsonGenerator.writeFieldName("fromInstanceName").writeValue(instanceSnapshot.getFromInstanceName());
            }
            if (instanceSnapshot.getFromInstanceArn() != null) {
                jsonGenerator.writeFieldName("fromInstanceArn").writeValue(instanceSnapshot.getFromInstanceArn());
            }
            if (instanceSnapshot.getFromBlueprintId() != null) {
                jsonGenerator.writeFieldName("fromBlueprintId").writeValue(instanceSnapshot.getFromBlueprintId());
            }
            if (instanceSnapshot.getFromBundleId() != null) {
                jsonGenerator.writeFieldName("fromBundleId").writeValue(instanceSnapshot.getFromBundleId());
            }
            if (instanceSnapshot.getSizeInGb() != null) {
                jsonGenerator.writeFieldName("sizeInGb").writeValue(instanceSnapshot.getSizeInGb());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static InstanceSnapshotJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new InstanceSnapshotJsonMarshaller();
        }
        return instance;
    }
}

