/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lightsail.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.lightsail.model.GetInstanceMetricDataRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.util.List;

public class GetInstanceMetricDataRequestMarshaller
implements Marshaller<Request<GetInstanceMetricDataRequest>, GetInstanceMetricDataRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public GetInstanceMetricDataRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<GetInstanceMetricDataRequest> marshall(GetInstanceMetricDataRequest getInstanceMetricDataRequest) {
        if (getInstanceMetricDataRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<GetInstanceMetricDataRequest> request = new DefaultRequest<GetInstanceMetricDataRequest>(getInstanceMetricDataRequest, "AmazonLightsail");
        request.addHeader("X-Amz-Target", "Lightsail_20161128.GetInstanceMetricData");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            List<String> statisticsList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (getInstanceMetricDataRequest.getInstanceName() != null) {
                jsonGenerator.writeFieldName("instanceName").writeValue(getInstanceMetricDataRequest.getInstanceName());
            }
            if (getInstanceMetricDataRequest.getMetricName() != null) {
                jsonGenerator.writeFieldName("metricName").writeValue(getInstanceMetricDataRequest.getMetricName());
            }
            if (getInstanceMetricDataRequest.getPeriod() != null) {
                jsonGenerator.writeFieldName("period").writeValue(getInstanceMetricDataRequest.getPeriod());
            }
            if (getInstanceMetricDataRequest.getStartTime() != null) {
                jsonGenerator.writeFieldName("startTime").writeValue(getInstanceMetricDataRequest.getStartTime());
            }
            if (getInstanceMetricDataRequest.getEndTime() != null) {
                jsonGenerator.writeFieldName("endTime").writeValue(getInstanceMetricDataRequest.getEndTime());
            }
            if (getInstanceMetricDataRequest.getUnit() != null) {
                jsonGenerator.writeFieldName("unit").writeValue(getInstanceMetricDataRequest.getUnit());
            }
            if ((statisticsList = getInstanceMetricDataRequest.getStatistics()) != null) {
                jsonGenerator.writeFieldName("statistics");
                jsonGenerator.writeStartArray();
                for (String statisticsListValue : statisticsList) {
                    if (statisticsListValue == null) continue;
                    jsonGenerator.writeValue(statisticsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

