/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lightsail.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.lightsail.model.AttachStaticIpRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class AttachStaticIpRequestMarshaller
implements Marshaller<Request<AttachStaticIpRequest>, AttachStaticIpRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public AttachStaticIpRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<AttachStaticIpRequest> marshall(AttachStaticIpRequest attachStaticIpRequest) {
        if (attachStaticIpRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<AttachStaticIpRequest> request = new DefaultRequest<AttachStaticIpRequest>(attachStaticIpRequest, "AmazonLightsail");
        request.addHeader("X-Amz-Target", "Lightsail_20161128.AttachStaticIp");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (attachStaticIpRequest.getStaticIpName() != null) {
                jsonGenerator.writeFieldName("staticIpName").writeValue(attachStaticIpRequest.getStaticIpName());
            }
            if (attachStaticIpRequest.getInstanceName() != null) {
                jsonGenerator.writeFieldName("instanceName").writeValue(attachStaticIpRequest.getInstanceName());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

