/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.health.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.health.model.DescribeEventsRequest;
import com.amazonaws.services.health.model.transform.EventFilterJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class DescribeEventsRequestMarshaller
implements Marshaller<Request<DescribeEventsRequest>, DescribeEventsRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public DescribeEventsRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<DescribeEventsRequest> marshall(DescribeEventsRequest describeEventsRequest) {
        if (describeEventsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeEventsRequest> request = new DefaultRequest<DescribeEventsRequest>(describeEventsRequest, "AWSHealth");
        request.addHeader("X-Amz-Target", "AWSHealth_20160804.DescribeEvents");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (describeEventsRequest.getFilter() != null) {
                jsonGenerator.writeFieldName("filter");
                EventFilterJsonMarshaller.getInstance().marshall(describeEventsRequest.getFilter(), jsonGenerator);
            }
            if (describeEventsRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("nextToken").writeValue(describeEventsRequest.getNextToken());
            }
            if (describeEventsRequest.getMaxResults() != null) {
                jsonGenerator.writeFieldName("maxResults").writeValue(describeEventsRequest.getMaxResults());
            }
            if (describeEventsRequest.getLocale() != null) {
                jsonGenerator.writeFieldName("locale").writeValue(describeEventsRequest.getLocale());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

