/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glacier.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.glacier.model.InitiateJobRequest;
import com.amazonaws.services.glacier.model.JobParameters;
import com.amazonaws.services.glacier.model.transform.InventoryRetrievalJobInputJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class InitiateJobRequestMarshaller
implements Marshaller<Request<InitiateJobRequest>, InitiateJobRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public InitiateJobRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<InitiateJobRequest> marshall(InitiateJobRequest initiateJobRequest) {
        if (initiateJobRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<InitiateJobRequest> request = new DefaultRequest<InitiateJobRequest>(initiateJobRequest, "AmazonGlacier");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/{accountId}/vaults/{vaultName}/jobs";
        uriResourcePath = uriResourcePath.replace("{accountId}", initiateJobRequest.getAccountId() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(initiateJobRequest.getAccountId()), false) : "");
        uriResourcePath = uriResourcePath.replace("{vaultName}", initiateJobRequest.getVaultName() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(initiateJobRequest.getVaultName()), false) : "");
        request.setResourcePath(uriResourcePath);
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            JobParameters jobParameters = initiateJobRequest.getJobParameters();
            if (jobParameters != null) {
                jsonGenerator.writeStartObject();
                if (jobParameters.getFormat() != null) {
                    jsonGenerator.writeFieldName("Format").writeValue(jobParameters.getFormat());
                }
                if (jobParameters.getType() != null) {
                    jsonGenerator.writeFieldName("Type").writeValue(jobParameters.getType());
                }
                if (jobParameters.getArchiveId() != null) {
                    jsonGenerator.writeFieldName("ArchiveId").writeValue(jobParameters.getArchiveId());
                }
                if (jobParameters.getDescription() != null) {
                    jsonGenerator.writeFieldName("Description").writeValue(jobParameters.getDescription());
                }
                if (jobParameters.getSNSTopic() != null) {
                    jsonGenerator.writeFieldName("SNSTopic").writeValue(jobParameters.getSNSTopic());
                }
                if (jobParameters.getRetrievalByteRange() != null) {
                    jsonGenerator.writeFieldName("RetrievalByteRange").writeValue(jobParameters.getRetrievalByteRange());
                }
                if (jobParameters.getTier() != null) {
                    jsonGenerator.writeFieldName("Tier").writeValue(jobParameters.getTier());
                }
                if (jobParameters.getInventoryRetrievalParameters() != null) {
                    jsonGenerator.writeFieldName("InventoryRetrievalParameters");
                    InventoryRetrievalJobInputJsonMarshaller.getInstance().marshall(jobParameters.getInventoryRetrievalParameters(), jsonGenerator);
                }
                jsonGenerator.writeEndObject();
            }
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", this.protocolFactory.getContentType());
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

