/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecr.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.ecr.model.ImageDetail;
import java.util.List;

public class ImageDetailJsonMarshaller {
    private static ImageDetailJsonMarshaller instance;

    public void marshall(ImageDetail imageDetail, StructuredJsonGenerator jsonGenerator) {
        if (imageDetail == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<String> imageTagsList;
            jsonGenerator.writeStartObject();
            if (imageDetail.getRegistryId() != null) {
                jsonGenerator.writeFieldName("registryId").writeValue(imageDetail.getRegistryId());
            }
            if (imageDetail.getRepositoryName() != null) {
                jsonGenerator.writeFieldName("repositoryName").writeValue(imageDetail.getRepositoryName());
            }
            if (imageDetail.getImageDigest() != null) {
                jsonGenerator.writeFieldName("imageDigest").writeValue(imageDetail.getImageDigest());
            }
            if ((imageTagsList = imageDetail.getImageTags()) != null) {
                jsonGenerator.writeFieldName("imageTags");
                jsonGenerator.writeStartArray();
                for (String imageTagsListValue : imageTagsList) {
                    if (imageTagsListValue == null) continue;
                    jsonGenerator.writeValue(imageTagsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (imageDetail.getImageSizeInBytes() != null) {
                jsonGenerator.writeFieldName("imageSizeInBytes").writeValue(imageDetail.getImageSizeInBytes());
            }
            if (imageDetail.getImagePushedAt() != null) {
                jsonGenerator.writeFieldName("imagePushedAt").writeValue(imageDetail.getImagePushedAt());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ImageDetailJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ImageDetailJsonMarshaller();
        }
        return instance;
    }
}

