/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.directconnect.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.directconnect.model.DeleteBGPPeerRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class DeleteBGPPeerRequestMarshaller
implements Marshaller<Request<DeleteBGPPeerRequest>, DeleteBGPPeerRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public DeleteBGPPeerRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<DeleteBGPPeerRequest> marshall(DeleteBGPPeerRequest deleteBGPPeerRequest) {
        if (deleteBGPPeerRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DeleteBGPPeerRequest> request = new DefaultRequest<DeleteBGPPeerRequest>(deleteBGPPeerRequest, "AmazonDirectConnect");
        request.addHeader("X-Amz-Target", "OvertureService.DeleteBGPPeer");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (deleteBGPPeerRequest.getVirtualInterfaceId() != null) {
                jsonGenerator.writeFieldName("virtualInterfaceId").writeValue(deleteBGPPeerRequest.getVirtualInterfaceId());
            }
            if (deleteBGPPeerRequest.getAsn() != null) {
                jsonGenerator.writeFieldName("asn").writeValue(deleteBGPPeerRequest.getAsn());
            }
            if (deleteBGPPeerRequest.getCustomerAddress() != null) {
                jsonGenerator.writeFieldName("customerAddress").writeValue(deleteBGPPeerRequest.getCustomerAddress());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

