/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudtrail.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.cloudtrail.model.EventSelector;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class PutEventSelectorsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String trailName;
    private SdkInternalList<EventSelector> eventSelectors;

    public void setTrailName(String trailName) {
        this.trailName = trailName;
    }

    public String getTrailName() {
        return this.trailName;
    }

    public PutEventSelectorsRequest withTrailName(String trailName) {
        this.setTrailName(trailName);
        return this;
    }

    public List<EventSelector> getEventSelectors() {
        if (this.eventSelectors == null) {
            this.eventSelectors = new SdkInternalList();
        }
        return this.eventSelectors;
    }

    public void setEventSelectors(Collection<EventSelector> eventSelectors) {
        if (eventSelectors == null) {
            this.eventSelectors = null;
            return;
        }
        this.eventSelectors = new SdkInternalList<EventSelector>(eventSelectors);
    }

    public PutEventSelectorsRequest withEventSelectors(EventSelector ... eventSelectors) {
        if (this.eventSelectors == null) {
            this.setEventSelectors(new SdkInternalList<EventSelector>(eventSelectors.length));
        }
        for (EventSelector ele : eventSelectors) {
            this.eventSelectors.add(ele);
        }
        return this;
    }

    public PutEventSelectorsRequest withEventSelectors(Collection<EventSelector> eventSelectors) {
        this.setEventSelectors(eventSelectors);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTrailName() != null) {
            sb.append("TrailName: " + this.getTrailName() + ",");
        }
        if (this.getEventSelectors() != null) {
            sb.append("EventSelectors: " + this.getEventSelectors());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutEventSelectorsRequest)) {
            return false;
        }
        PutEventSelectorsRequest other = (PutEventSelectorsRequest)obj;
        if (other.getTrailName() == null ^ this.getTrailName() == null) {
            return false;
        }
        if (other.getTrailName() != null && !other.getTrailName().equals(this.getTrailName())) {
            return false;
        }
        if (other.getEventSelectors() == null ^ this.getEventSelectors() == null) {
            return false;
        }
        return other.getEventSelectors() == null || other.getEventSelectors().equals(this.getEventSelectors());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTrailName() == null ? 0 : this.getTrailName().hashCode());
        hashCode = 31 * hashCode + (this.getEventSelectors() == null ? 0 : this.getEventSelectors().hashCode());
        return hashCode;
    }

    @Override
    public PutEventSelectorsRequest clone() {
        return (PutEventSelectorsRequest)super.clone();
    }
}

