/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.kinesis.model.UpdateShardCountRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class UpdateShardCountRequestMarshaller
implements Marshaller<Request<UpdateShardCountRequest>, UpdateShardCountRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public UpdateShardCountRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<UpdateShardCountRequest> marshall(UpdateShardCountRequest updateShardCountRequest) {
        if (updateShardCountRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<UpdateShardCountRequest> request = new DefaultRequest<UpdateShardCountRequest>(updateShardCountRequest, "AmazonKinesis");
        request.addHeader("X-Amz-Target", "Kinesis_20131202.UpdateShardCount");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (updateShardCountRequest.getStreamName() != null) {
                jsonGenerator.writeFieldName("StreamName").writeValue(updateShardCountRequest.getStreamName());
            }
            if (updateShardCountRequest.getTargetShardCount() != null) {
                jsonGenerator.writeFieldName("TargetShardCount").writeValue(updateShardCountRequest.getTargetShardCount());
            }
            if (updateShardCountRequest.getScalingType() != null) {
                jsonGenerator.writeFieldName("ScalingType").writeValue(updateShardCountRequest.getScalingType());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

