/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DescribeVpcsRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeVpcsRequestMarshaller
implements Marshaller<Request<DescribeVpcsRequest>, DescribeVpcsRequest> {
    @Override
    public Request<DescribeVpcsRequest> marshall(DescribeVpcsRequest describeVpcsRequest) {
        SdkInternalList describeVpcsRequestFiltersList;
        if (describeVpcsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeVpcsRequest> request = new DefaultRequest<DescribeVpcsRequest>(describeVpcsRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeVpcs");
        request.addParameter("Version", "2016-09-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList describeVpcsRequestVpcIdsList = (SdkInternalList)describeVpcsRequest.getVpcIds();
        if (!describeVpcsRequestVpcIdsList.isEmpty() || !describeVpcsRequestVpcIdsList.isAutoConstruct()) {
            int vpcIdsListIndex = 1;
            for (String describeVpcsRequestVpcIdsListValue : describeVpcsRequestVpcIdsList) {
                if (describeVpcsRequestVpcIdsListValue != null) {
                    request.addParameter("VpcId." + vpcIdsListIndex, StringUtils.fromString(describeVpcsRequestVpcIdsListValue));
                }
                ++vpcIdsListIndex;
            }
        }
        if (!(describeVpcsRequestFiltersList = (SdkInternalList)describeVpcsRequest.getFilters()).isEmpty() || !describeVpcsRequestFiltersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Filter describeVpcsRequestFiltersListValue : describeVpcsRequestFiltersList) {
                SdkInternalList filterValuesList;
                if (describeVpcsRequestFiltersListValue.getName() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString(describeVpcsRequestFiltersListValue.getName()));
                }
                if (!(filterValuesList = (SdkInternalList)describeVpcsRequestFiltersListValue.getValues()).isEmpty() || !filterValuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString(filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        return request;
    }
}

