/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.ec2.model.AssociateAddressRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class AssociateAddressRequestMarshaller
implements Marshaller<Request<AssociateAddressRequest>, AssociateAddressRequest> {
    @Override
    public Request<AssociateAddressRequest> marshall(AssociateAddressRequest associateAddressRequest) {
        if (associateAddressRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<AssociateAddressRequest> request = new DefaultRequest<AssociateAddressRequest>(associateAddressRequest, "AmazonEC2");
        request.addParameter("Action", "AssociateAddress");
        request.addParameter("Version", "2016-09-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (associateAddressRequest.getInstanceId() != null) {
            request.addParameter("InstanceId", StringUtils.fromString(associateAddressRequest.getInstanceId()));
        }
        if (associateAddressRequest.getPublicIp() != null) {
            request.addParameter("PublicIp", StringUtils.fromString(associateAddressRequest.getPublicIp()));
        }
        if (associateAddressRequest.getAllocationId() != null) {
            request.addParameter("AllocationId", StringUtils.fromString(associateAddressRequest.getAllocationId()));
        }
        if (associateAddressRequest.getNetworkInterfaceId() != null) {
            request.addParameter("NetworkInterfaceId", StringUtils.fromString(associateAddressRequest.getNetworkInterfaceId()));
        }
        if (associateAddressRequest.getPrivateIpAddress() != null) {
            request.addParameter("PrivateIpAddress", StringUtils.fromString(associateAddressRequest.getPrivateIpAddress()));
        }
        if (associateAddressRequest.getAllowReassociation() != null) {
            request.addParameter("AllowReassociation", StringUtils.fromBoolean(associateAddressRequest.getAllowReassociation()));
        }
        return request;
    }
}

