/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.apigateway.model.DeleteIntegrationResponseRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class DeleteIntegrationResponseRequestMarshaller
implements Marshaller<Request<DeleteIntegrationResponseRequest>, DeleteIntegrationResponseRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public DeleteIntegrationResponseRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<DeleteIntegrationResponseRequest> marshall(DeleteIntegrationResponseRequest deleteIntegrationResponseRequest) {
        if (deleteIntegrationResponseRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DeleteIntegrationResponseRequest> request = new DefaultRequest<DeleteIntegrationResponseRequest>(deleteIntegrationResponseRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.DELETE);
        String uriResourcePath = "/restapis/{restapi_id}/resources/{resource_id}/methods/{http_method}/integration/responses/{status_code}";
        uriResourcePath = uriResourcePath.replace("{restapi_id}", deleteIntegrationResponseRequest.getRestApiId() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(deleteIntegrationResponseRequest.getRestApiId()), false) : "");
        uriResourcePath = uriResourcePath.replace("{resource_id}", deleteIntegrationResponseRequest.getResourceId() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(deleteIntegrationResponseRequest.getResourceId()), false) : "");
        uriResourcePath = uriResourcePath.replace("{http_method}", deleteIntegrationResponseRequest.getHttpMethod() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(deleteIntegrationResponseRequest.getHttpMethod()), false) : "");
        uriResourcePath = uriResourcePath.replace("{status_code}", deleteIntegrationResponseRequest.getStatusCode() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(deleteIntegrationResponseRequest.getStatusCode()), false) : "");
        request.setResourcePath(uriResourcePath);
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

