/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.simplesystemsmanagement.model.Command;
import com.amazonaws.services.simplesystemsmanagement.model.transform.NotificationConfigJsonMarshaller;
import java.util.List;
import java.util.Map;

public class CommandJsonMarshaller {
    private static CommandJsonMarshaller instance;

    public void marshall(Command command, StructuredJsonGenerator jsonGenerator) {
        if (command == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList instanceIdsList;
            Map<String, List<String>> parametersMap;
            jsonGenerator.writeStartObject();
            if (command.getCommandId() != null) {
                jsonGenerator.writeFieldName("CommandId").writeValue(command.getCommandId());
            }
            if (command.getDocumentName() != null) {
                jsonGenerator.writeFieldName("DocumentName").writeValue(command.getDocumentName());
            }
            if (command.getComment() != null) {
                jsonGenerator.writeFieldName("Comment").writeValue(command.getComment());
            }
            if (command.getExpiresAfter() != null) {
                jsonGenerator.writeFieldName("ExpiresAfter").writeValue(command.getExpiresAfter());
            }
            if ((parametersMap = command.getParameters()) != null) {
                jsonGenerator.writeFieldName("Parameters");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, List<String>> parametersMapValue : parametersMap.entrySet()) {
                    if (parametersMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName(parametersMapValue.getKey());
                    jsonGenerator.writeStartArray();
                    for (String parametersMapValueList : parametersMapValue.getValue()) {
                        if (parametersMapValueList == null) continue;
                        jsonGenerator.writeValue(parametersMapValueList);
                    }
                    jsonGenerator.writeEndArray();
                }
                jsonGenerator.writeEndObject();
            }
            if (!(instanceIdsList = (SdkInternalList)command.getInstanceIds()).isEmpty() || !instanceIdsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("InstanceIds");
                jsonGenerator.writeStartArray();
                for (String instanceIdsListValue : instanceIdsList) {
                    if (instanceIdsListValue == null) continue;
                    jsonGenerator.writeValue(instanceIdsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (command.getRequestedDateTime() != null) {
                jsonGenerator.writeFieldName("RequestedDateTime").writeValue(command.getRequestedDateTime());
            }
            if (command.getStatus() != null) {
                jsonGenerator.writeFieldName("Status").writeValue(command.getStatus());
            }
            if (command.getOutputS3BucketName() != null) {
                jsonGenerator.writeFieldName("OutputS3BucketName").writeValue(command.getOutputS3BucketName());
            }
            if (command.getOutputS3KeyPrefix() != null) {
                jsonGenerator.writeFieldName("OutputS3KeyPrefix").writeValue(command.getOutputS3KeyPrefix());
            }
            if (command.getServiceRole() != null) {
                jsonGenerator.writeFieldName("ServiceRole").writeValue(command.getServiceRole());
            }
            if (command.getNotificationConfig() != null) {
                jsonGenerator.writeFieldName("NotificationConfig");
                NotificationConfigJsonMarshaller.getInstance().marshall(command.getNotificationConfig(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static CommandJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new CommandJsonMarshaller();
        }
        return instance;
    }
}

