/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.internal.SdkInternalMap;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.lambda.model.Environment;
import java.util.Map;

public class EnvironmentJsonMarshaller {
    private static EnvironmentJsonMarshaller instance;

    public void marshall(Environment environment, StructuredJsonGenerator jsonGenerator) {
        if (environment == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            SdkInternalMap variablesMap = (SdkInternalMap)environment.getVariables();
            if (!variablesMap.isEmpty() || !variablesMap.isAutoConstruct()) {
                jsonGenerator.writeFieldName("Variables");
                jsonGenerator.writeStartObject();
                for (Map.Entry variablesMapValue : variablesMap.entrySet()) {
                    if (variablesMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName((String)variablesMapValue.getKey());
                    jsonGenerator.writeValue((String)variablesMapValue.getValue());
                }
                jsonGenerator.writeEndObject();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static EnvironmentJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new EnvironmentJsonMarshaller();
        }
        return instance;
    }
}

