/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glacier.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.glacier.model.DeleteArchiveRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class DeleteArchiveRequestMarshaller
implements Marshaller<Request<DeleteArchiveRequest>, DeleteArchiveRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public DeleteArchiveRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<DeleteArchiveRequest> marshall(DeleteArchiveRequest deleteArchiveRequest) {
        if (deleteArchiveRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DeleteArchiveRequest> request = new DefaultRequest<DeleteArchiveRequest>(deleteArchiveRequest, "AmazonGlacier");
        request.setHttpMethod(HttpMethodName.DELETE);
        String uriResourcePath = "/{accountId}/vaults/{vaultName}/archives/{archiveId}";
        uriResourcePath = uriResourcePath.replace("{accountId}", deleteArchiveRequest.getAccountId() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(deleteArchiveRequest.getAccountId()), false) : "");
        uriResourcePath = uriResourcePath.replace("{vaultName}", deleteArchiveRequest.getVaultName() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(deleteArchiveRequest.getVaultName()), false) : "");
        uriResourcePath = uriResourcePath.replace("{archiveId}", deleteArchiveRequest.getArchiveId() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(deleteArchiveRequest.getArchiveId()), false) : "");
        request.setResourcePath(uriResourcePath);
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

