/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.inspector.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.inspector.model.Attribute;
import com.amazonaws.services.inspector.model.Finding;
import com.amazonaws.services.inspector.model.transform.AssetAttributesJsonMarshaller;
import com.amazonaws.services.inspector.model.transform.AttributeJsonMarshaller;
import com.amazonaws.services.inspector.model.transform.InspectorServiceAttributesJsonMarshaller;
import java.util.List;

public class FindingJsonMarshaller {
    private static FindingJsonMarshaller instance;

    public void marshall(Finding finding, StructuredJsonGenerator jsonGenerator) {
        if (finding == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<Attribute> userAttributesList;
            List<Attribute> attributesList;
            jsonGenerator.writeStartObject();
            if (finding.getArn() != null) {
                jsonGenerator.writeFieldName("arn").writeValue(finding.getArn());
            }
            if (finding.getSchemaVersion() != null) {
                jsonGenerator.writeFieldName("schemaVersion").writeValue(finding.getSchemaVersion());
            }
            if (finding.getService() != null) {
                jsonGenerator.writeFieldName("service").writeValue(finding.getService());
            }
            if (finding.getServiceAttributes() != null) {
                jsonGenerator.writeFieldName("serviceAttributes");
                InspectorServiceAttributesJsonMarshaller.getInstance().marshall(finding.getServiceAttributes(), jsonGenerator);
            }
            if (finding.getAssetType() != null) {
                jsonGenerator.writeFieldName("assetType").writeValue(finding.getAssetType());
            }
            if (finding.getAssetAttributes() != null) {
                jsonGenerator.writeFieldName("assetAttributes");
                AssetAttributesJsonMarshaller.getInstance().marshall(finding.getAssetAttributes(), jsonGenerator);
            }
            if (finding.getId() != null) {
                jsonGenerator.writeFieldName("id").writeValue(finding.getId());
            }
            if (finding.getTitle() != null) {
                jsonGenerator.writeFieldName("title").writeValue(finding.getTitle());
            }
            if (finding.getDescription() != null) {
                jsonGenerator.writeFieldName("description").writeValue(finding.getDescription());
            }
            if (finding.getRecommendation() != null) {
                jsonGenerator.writeFieldName("recommendation").writeValue(finding.getRecommendation());
            }
            if (finding.getSeverity() != null) {
                jsonGenerator.writeFieldName("severity").writeValue(finding.getSeverity());
            }
            if (finding.getNumericSeverity() != null) {
                jsonGenerator.writeFieldName("numericSeverity").writeValue(finding.getNumericSeverity());
            }
            if (finding.getConfidence() != null) {
                jsonGenerator.writeFieldName("confidence").writeValue(finding.getConfidence());
            }
            if (finding.getIndicatorOfCompromise() != null) {
                jsonGenerator.writeFieldName("indicatorOfCompromise").writeValue(finding.getIndicatorOfCompromise());
            }
            if ((attributesList = finding.getAttributes()) != null) {
                jsonGenerator.writeFieldName("attributes");
                jsonGenerator.writeStartArray();
                for (Attribute attributesListValue : attributesList) {
                    if (attributesListValue == null) continue;
                    AttributeJsonMarshaller.getInstance().marshall(attributesListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if ((userAttributesList = finding.getUserAttributes()) != null) {
                jsonGenerator.writeFieldName("userAttributes");
                jsonGenerator.writeStartArray();
                for (Attribute userAttributesListValue : userAttributesList) {
                    if (userAttributesListValue == null) continue;
                    AttributeJsonMarshaller.getInstance().marshall(userAttributesListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (finding.getCreatedAt() != null) {
                jsonGenerator.writeFieldName("createdAt").writeValue(finding.getCreatedAt());
            }
            if (finding.getUpdatedAt() != null) {
                jsonGenerator.writeFieldName("updatedAt").writeValue(finding.getUpdatedAt());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static FindingJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new FindingJsonMarshaller();
        }
        return instance;
    }
}

