/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.elasticmapreduce.model.KeyValue;

public class KeyValueJsonMarshaller {
    private static KeyValueJsonMarshaller instance;

    public void marshall(KeyValue keyValue, StructuredJsonGenerator jsonGenerator) {
        if (keyValue == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (keyValue.getKey() != null) {
                jsonGenerator.writeFieldName("Key").writeValue(keyValue.getKey());
            }
            if (keyValue.getValue() != null) {
                jsonGenerator.writeFieldName("Value").writeValue(keyValue.getValue());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static KeyValueJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new KeyValueJsonMarshaller();
        }
        return instance;
    }
}

