/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticloadbalancingv2.model;

import com.amazonaws.AmazonWebServiceRequest;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SetSecurityGroupsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String loadBalancerArn;
    private List<String> securityGroups;

    public void setLoadBalancerArn(String loadBalancerArn) {
        this.loadBalancerArn = loadBalancerArn;
    }

    public String getLoadBalancerArn() {
        return this.loadBalancerArn;
    }

    public SetSecurityGroupsRequest withLoadBalancerArn(String loadBalancerArn) {
        this.setLoadBalancerArn(loadBalancerArn);
        return this;
    }

    public List<String> getSecurityGroups() {
        return this.securityGroups;
    }

    public void setSecurityGroups(Collection<String> securityGroups) {
        if (securityGroups == null) {
            this.securityGroups = null;
            return;
        }
        this.securityGroups = new ArrayList<String>(securityGroups);
    }

    public SetSecurityGroupsRequest withSecurityGroups(String ... securityGroups) {
        if (this.securityGroups == null) {
            this.setSecurityGroups(new ArrayList<String>(securityGroups.length));
        }
        for (String ele : securityGroups) {
            this.securityGroups.add(ele);
        }
        return this;
    }

    public SetSecurityGroupsRequest withSecurityGroups(Collection<String> securityGroups) {
        this.setSecurityGroups(securityGroups);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getLoadBalancerArn() != null) {
            sb.append("LoadBalancerArn: " + this.getLoadBalancerArn() + ",");
        }
        if (this.getSecurityGroups() != null) {
            sb.append("SecurityGroups: " + this.getSecurityGroups());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetSecurityGroupsRequest)) {
            return false;
        }
        SetSecurityGroupsRequest other = (SetSecurityGroupsRequest)obj;
        if (other.getLoadBalancerArn() == null ^ this.getLoadBalancerArn() == null) {
            return false;
        }
        if (other.getLoadBalancerArn() != null && !other.getLoadBalancerArn().equals(this.getLoadBalancerArn())) {
            return false;
        }
        if (other.getSecurityGroups() == null ^ this.getSecurityGroups() == null) {
            return false;
        }
        return other.getSecurityGroups() == null || other.getSecurityGroups().equals(this.getSecurityGroups());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getLoadBalancerArn() == null ? 0 : this.getLoadBalancerArn().hashCode());
        hashCode = 31 * hashCode + (this.getSecurityGroups() == null ? 0 : this.getSecurityGroups().hashCode());
        return hashCode;
    }

    @Override
    public SetSecurityGroupsRequest clone() {
        return (SetSecurityGroupsRequest)super.clone();
    }
}

