/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.apigateway.model.Integration;
import com.amazonaws.services.apigateway.model.MethodResponse;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class PutMethodResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String httpMethod;
    private String authorizationType;
    private String authorizerId;
    private Boolean apiKeyRequired;
    private Map<String, Boolean> requestParameters;
    private Map<String, String> requestModels;
    private Map<String, MethodResponse> methodResponses;
    private Integration methodIntegration;

    public void setHttpMethod(String httpMethod) {
        this.httpMethod = httpMethod;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public PutMethodResult withHttpMethod(String httpMethod) {
        this.setHttpMethod(httpMethod);
        return this;
    }

    public void setAuthorizationType(String authorizationType) {
        this.authorizationType = authorizationType;
    }

    public String getAuthorizationType() {
        return this.authorizationType;
    }

    public PutMethodResult withAuthorizationType(String authorizationType) {
        this.setAuthorizationType(authorizationType);
        return this;
    }

    public void setAuthorizerId(String authorizerId) {
        this.authorizerId = authorizerId;
    }

    public String getAuthorizerId() {
        return this.authorizerId;
    }

    public PutMethodResult withAuthorizerId(String authorizerId) {
        this.setAuthorizerId(authorizerId);
        return this;
    }

    public void setApiKeyRequired(Boolean apiKeyRequired) {
        this.apiKeyRequired = apiKeyRequired;
    }

    public Boolean getApiKeyRequired() {
        return this.apiKeyRequired;
    }

    public PutMethodResult withApiKeyRequired(Boolean apiKeyRequired) {
        this.setApiKeyRequired(apiKeyRequired);
        return this;
    }

    public Boolean isApiKeyRequired() {
        return this.apiKeyRequired;
    }

    public Map<String, Boolean> getRequestParameters() {
        return this.requestParameters;
    }

    public void setRequestParameters(Map<String, Boolean> requestParameters) {
        this.requestParameters = requestParameters;
    }

    public PutMethodResult withRequestParameters(Map<String, Boolean> requestParameters) {
        this.setRequestParameters(requestParameters);
        return this;
    }

    public PutMethodResult addRequestParametersEntry(String key, Boolean value) {
        if (null == this.requestParameters) {
            this.requestParameters = new HashMap<String, Boolean>();
        }
        if (this.requestParameters.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.requestParameters.put(key, value);
        return this;
    }

    public PutMethodResult clearRequestParametersEntries() {
        this.requestParameters = null;
        return this;
    }

    public Map<String, String> getRequestModels() {
        return this.requestModels;
    }

    public void setRequestModels(Map<String, String> requestModels) {
        this.requestModels = requestModels;
    }

    public PutMethodResult withRequestModels(Map<String, String> requestModels) {
        this.setRequestModels(requestModels);
        return this;
    }

    public PutMethodResult addRequestModelsEntry(String key, String value) {
        if (null == this.requestModels) {
            this.requestModels = new HashMap<String, String>();
        }
        if (this.requestModels.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.requestModels.put(key, value);
        return this;
    }

    public PutMethodResult clearRequestModelsEntries() {
        this.requestModels = null;
        return this;
    }

    public Map<String, MethodResponse> getMethodResponses() {
        return this.methodResponses;
    }

    public void setMethodResponses(Map<String, MethodResponse> methodResponses) {
        this.methodResponses = methodResponses;
    }

    public PutMethodResult withMethodResponses(Map<String, MethodResponse> methodResponses) {
        this.setMethodResponses(methodResponses);
        return this;
    }

    public PutMethodResult addMethodResponsesEntry(String key, MethodResponse value) {
        if (null == this.methodResponses) {
            this.methodResponses = new HashMap<String, MethodResponse>();
        }
        if (this.methodResponses.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.methodResponses.put(key, value);
        return this;
    }

    public PutMethodResult clearMethodResponsesEntries() {
        this.methodResponses = null;
        return this;
    }

    public void setMethodIntegration(Integration methodIntegration) {
        this.methodIntegration = methodIntegration;
    }

    public Integration getMethodIntegration() {
        return this.methodIntegration;
    }

    public PutMethodResult withMethodIntegration(Integration methodIntegration) {
        this.setMethodIntegration(methodIntegration);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getHttpMethod() != null) {
            sb.append("HttpMethod: " + this.getHttpMethod() + ",");
        }
        if (this.getAuthorizationType() != null) {
            sb.append("AuthorizationType: " + this.getAuthorizationType() + ",");
        }
        if (this.getAuthorizerId() != null) {
            sb.append("AuthorizerId: " + this.getAuthorizerId() + ",");
        }
        if (this.getApiKeyRequired() != null) {
            sb.append("ApiKeyRequired: " + this.getApiKeyRequired() + ",");
        }
        if (this.getRequestParameters() != null) {
            sb.append("RequestParameters: " + this.getRequestParameters() + ",");
        }
        if (this.getRequestModels() != null) {
            sb.append("RequestModels: " + this.getRequestModels() + ",");
        }
        if (this.getMethodResponses() != null) {
            sb.append("MethodResponses: " + this.getMethodResponses() + ",");
        }
        if (this.getMethodIntegration() != null) {
            sb.append("MethodIntegration: " + this.getMethodIntegration());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutMethodResult)) {
            return false;
        }
        PutMethodResult other = (PutMethodResult)obj;
        if (other.getHttpMethod() == null ^ this.getHttpMethod() == null) {
            return false;
        }
        if (other.getHttpMethod() != null && !other.getHttpMethod().equals(this.getHttpMethod())) {
            return false;
        }
        if (other.getAuthorizationType() == null ^ this.getAuthorizationType() == null) {
            return false;
        }
        if (other.getAuthorizationType() != null && !other.getAuthorizationType().equals(this.getAuthorizationType())) {
            return false;
        }
        if (other.getAuthorizerId() == null ^ this.getAuthorizerId() == null) {
            return false;
        }
        if (other.getAuthorizerId() != null && !other.getAuthorizerId().equals(this.getAuthorizerId())) {
            return false;
        }
        if (other.getApiKeyRequired() == null ^ this.getApiKeyRequired() == null) {
            return false;
        }
        if (other.getApiKeyRequired() != null && !other.getApiKeyRequired().equals(this.getApiKeyRequired())) {
            return false;
        }
        if (other.getRequestParameters() == null ^ this.getRequestParameters() == null) {
            return false;
        }
        if (other.getRequestParameters() != null && !other.getRequestParameters().equals(this.getRequestParameters())) {
            return false;
        }
        if (other.getRequestModels() == null ^ this.getRequestModels() == null) {
            return false;
        }
        if (other.getRequestModels() != null && !other.getRequestModels().equals(this.getRequestModels())) {
            return false;
        }
        if (other.getMethodResponses() == null ^ this.getMethodResponses() == null) {
            return false;
        }
        if (other.getMethodResponses() != null && !other.getMethodResponses().equals(this.getMethodResponses())) {
            return false;
        }
        if (other.getMethodIntegration() == null ^ this.getMethodIntegration() == null) {
            return false;
        }
        return other.getMethodIntegration() == null || other.getMethodIntegration().equals(this.getMethodIntegration());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getHttpMethod() == null ? 0 : this.getHttpMethod().hashCode());
        hashCode = 31 * hashCode + (this.getAuthorizationType() == null ? 0 : this.getAuthorizationType().hashCode());
        hashCode = 31 * hashCode + (this.getAuthorizerId() == null ? 0 : this.getAuthorizerId().hashCode());
        hashCode = 31 * hashCode + (this.getApiKeyRequired() == null ? 0 : this.getApiKeyRequired().hashCode());
        hashCode = 31 * hashCode + (this.getRequestParameters() == null ? 0 : this.getRequestParameters().hashCode());
        hashCode = 31 * hashCode + (this.getRequestModels() == null ? 0 : this.getRequestModels().hashCode());
        hashCode = 31 * hashCode + (this.getMethodResponses() == null ? 0 : this.getMethodResponses().hashCode());
        hashCode = 31 * hashCode + (this.getMethodIntegration() == null ? 0 : this.getMethodIntegration().hashCode());
        return hashCode;
    }

    public PutMethodResult clone() {
        try {
            return (PutMethodResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

