/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.snowball.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.snowball.model.ShippingDetails;
import com.amazonaws.services.snowball.model.transform.ShipmentJsonMarshaller;

public class ShippingDetailsJsonMarshaller {
    private static ShippingDetailsJsonMarshaller instance;

    public void marshall(ShippingDetails shippingDetails, StructuredJsonGenerator jsonGenerator) {
        if (shippingDetails == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (shippingDetails.getShippingOption() != null) {
                jsonGenerator.writeFieldName("ShippingOption").writeValue(shippingDetails.getShippingOption());
            }
            if (shippingDetails.getInboundShipment() != null) {
                jsonGenerator.writeFieldName("InboundShipment");
                ShipmentJsonMarshaller.getInstance().marshall(shippingDetails.getInboundShipment(), jsonGenerator);
            }
            if (shippingDetails.getOutboundShipment() != null) {
                jsonGenerator.writeFieldName("OutboundShipment");
                ShipmentJsonMarshaller.getInstance().marshall(shippingDetails.getOutboundShipment(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ShippingDetailsJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ShippingDetailsJsonMarshaller();
        }
        return instance;
    }
}

