/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.simplesystemsmanagement.model.CommandFilter;
import com.amazonaws.services.simplesystemsmanagement.model.ListCommandsRequest;
import com.amazonaws.services.simplesystemsmanagement.model.transform.CommandFilterJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class ListCommandsRequestMarshaller
implements Marshaller<Request<ListCommandsRequest>, ListCommandsRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public ListCommandsRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<ListCommandsRequest> marshall(ListCommandsRequest listCommandsRequest) {
        if (listCommandsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListCommandsRequest> request = new DefaultRequest<ListCommandsRequest>(listCommandsRequest, "AWSSimpleSystemsManagement");
        request.addHeader("X-Amz-Target", "AmazonSSM.ListCommands");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList filtersList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (listCommandsRequest.getCommandId() != null) {
                jsonGenerator.writeFieldName("CommandId").writeValue(listCommandsRequest.getCommandId());
            }
            if (listCommandsRequest.getInstanceId() != null) {
                jsonGenerator.writeFieldName("InstanceId").writeValue(listCommandsRequest.getInstanceId());
            }
            if (listCommandsRequest.getMaxResults() != null) {
                jsonGenerator.writeFieldName("MaxResults").writeValue(listCommandsRequest.getMaxResults());
            }
            if (listCommandsRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("NextToken").writeValue(listCommandsRequest.getNextToken());
            }
            if (!(filtersList = (SdkInternalList)listCommandsRequest.getFilters()).isEmpty() || !filtersList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("Filters");
                jsonGenerator.writeStartArray();
                for (CommandFilter filtersListValue : filtersList) {
                    if (filtersListValue == null) continue;
                    CommandFilterJsonMarshaller.getInstance().marshall(filtersListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

