/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.route53.model.Change;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ChangeBatch
implements Serializable,
Cloneable {
    private String comment;
    private SdkInternalList<Change> changes;

    public ChangeBatch() {
    }

    public ChangeBatch(List<Change> changes) {
        this.setChanges(changes);
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getComment() {
        return this.comment;
    }

    public ChangeBatch withComment(String comment) {
        this.setComment(comment);
        return this;
    }

    public List<Change> getChanges() {
        if (this.changes == null) {
            this.changes = new SdkInternalList();
        }
        return this.changes;
    }

    public void setChanges(Collection<Change> changes) {
        if (changes == null) {
            this.changes = null;
            return;
        }
        this.changes = new SdkInternalList<Change>(changes);
    }

    public ChangeBatch withChanges(Change ... changes) {
        if (this.changes == null) {
            this.setChanges(new SdkInternalList<Change>(changes.length));
        }
        for (Change ele : changes) {
            this.changes.add(ele);
        }
        return this;
    }

    public ChangeBatch withChanges(Collection<Change> changes) {
        this.setChanges(changes);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getComment() != null) {
            sb.append("Comment: " + this.getComment() + ",");
        }
        if (this.getChanges() != null) {
            sb.append("Changes: " + this.getChanges());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChangeBatch)) {
            return false;
        }
        ChangeBatch other = (ChangeBatch)obj;
        if (other.getComment() == null ^ this.getComment() == null) {
            return false;
        }
        if (other.getComment() != null && !other.getComment().equals(this.getComment())) {
            return false;
        }
        if (other.getChanges() == null ^ this.getChanges() == null) {
            return false;
        }
        return other.getChanges() == null || other.getChanges().equals(this.getChanges());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getComment() == null ? 0 : this.getComment().hashCode());
        hashCode = 31 * hashCode + (this.getChanges() == null ? 0 : this.getChanges().hashCode());
        return hashCode;
    }

    public ChangeBatch clone() {
        try {
            return (ChangeBatch)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

